/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.maven.verifier;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.aether.RepositorySystemSession;
import org.springframework.cloud.contract.maven.verifier.stubrunner.LocalStubRunner;
import org.springframework.cloud.contract.maven.verifier.stubrunner.RemoteStubRunner;
import org.springframework.cloud.contract.stubrunner.BatchStubRunner;
import org.springframework.cloud.contract.stubrunner.StubRunner;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptions;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptionsBuilder;
import org.springframework.util.StringUtils;

@Mojo(name="run", requiresProject=false, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class RunMojo
extends AbstractMojo {
    private final LocalStubRunner localStubRunner;
    private final RemoteStubRunner remoteStubRunner;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.build.directory}/stubs/")
    private File stubsDirectory;
    @Parameter(property="stubsDirectory", defaultValue="${basedir}")
    private File destination;
    @Parameter(property="spring.cloud.contract.verifier.http.port", defaultValue="8080")
    private int httpPort;
    @Parameter(property="spring.cloud.contract.verifier.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="spring.cloud.contract.verifier.skipTestOnly", defaultValue="false")
    private boolean skipTestOnly;
    @Parameter(property="spring.cloud.contract.verifier.stubs")
    private String stubs;
    @Parameter(property="spring.cloud.contract.verifier.http.minPort", defaultValue="10000")
    private int minPort;
    @Parameter(property="spring.cloud.contract.verifier.http.maxPort", defaultValue="15000")
    private int maxPort;
    @Parameter(property="spring.cloud.contract.verifier.wait-for-key-pressed", defaultValue="true")
    private boolean waitForKeyPressed;
    @Parameter(defaultValue="stubs")
    private String stubsClassifier = "stubs";
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession mavenSession;

    @Inject
    public RunMojo(LocalStubRunner localStubRunner, RemoteStubRunner remoteStubRunner) {
        this.localStubRunner = localStubRunner;
        this.remoteStubRunner = remoteStubRunner;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        StubRunnerOptions options;
        if (this.skip || this.skipTestOnly) {
            this.getLog().info((CharSequence)("Skipping verifier execution: spring.cloud.contract.verifier.skip=" + this.skip));
            return;
        }
        BatchStubRunner batchStubRunner = null;
        StubRunnerOptionsBuilder optionsBuilder = new StubRunnerOptionsBuilder().withStubsClassifier(this.stubsClassifier);
        if (StringUtils.isEmpty((Object)this.stubs)) {
            options = optionsBuilder.withMinMaxPort(Integer.valueOf(this.httpPort), Integer.valueOf(this.httpPort)).build();
            StubRunner stubRunner = this.localStubRunner.run(this.resolveStubsDirectory().getAbsolutePath(), options);
            batchStubRunner = new BatchStubRunner(Collections.singleton(stubRunner));
        } else {
            options = optionsBuilder.withStubs(new String[]{this.stubs}).withMinMaxPort(Integer.valueOf(this.minPort), Integer.valueOf(this.maxPort)).build();
            batchStubRunner = this.remoteStubRunner.run(options, this.repoSession);
        }
        this.pressAnyKeyToContinue();
        if (batchStubRunner != null) {
            try {
                batchStubRunner.close();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Fail to close batch stub runner", (Exception)e);
            }
        }
    }

    private File resolveStubsDirectory() {
        if (this.isInsideProject()) {
            return this.stubsDirectory;
        }
        return this.destination;
    }

    private void pressAnyKeyToContinue() {
        if (!this.waitForKeyPressed) {
            return;
        }
        this.getLog().info((CharSequence)"Press ENTER to continue...");
        try {
            System.in.read();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isInsideProject() {
        return this.mavenSession.getRequest().isProjectPresent();
    }
}

