/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.maven.verifier;

import java.io.File;
import java.util.Map;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.springframework.cloud.contract.stubrunner.ContractDownloader;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;
import org.springframework.cloud.contract.stubrunner.StubDownloader;
import org.springframework.cloud.contract.stubrunner.StubDownloaderBuilder;
import org.springframework.cloud.contract.stubrunner.StubDownloaderBuilderProvider;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptions;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptionsBuilder;
import org.springframework.cloud.contract.stubrunner.spring.StubRunnerProperties;
import org.springframework.cloud.contract.verifier.config.ContractVerifierConfigProperties;
import org.springframework.util.StringUtils;

class MavenContractsDownloader {
    private static final String LATEST_VERSION = "+";
    private static final String CONTRACTS_DIRECTORY_PROP = "CONTRACTS_DIRECTORY";
    private final MavenProject project;
    private final Dependency contractDependency;
    private final String contractsPath;
    private final String contractsRepositoryUrl;
    private final StubRunnerProperties.StubsMode stubsMode;
    private final Log log;
    private final StubDownloaderBuilderProvider stubDownloaderBuilderProvider;
    private final String repositoryUsername;
    private final String repositoryPassword;
    private final String repositoryProxyHost;
    private final Integer repositoryProxyPort;
    private final boolean deleteStubsAfterTest;
    private final Map<String, String> contractsProperties;
    private final boolean failOnNoStubs;

    MavenContractsDownloader(MavenProject project, Dependency contractDependency, String contractsPath, String contractsRepositoryUrl, StubRunnerProperties.StubsMode stubsMode, Log log, String repositoryUsername, String repositoryPassword, String repositoryProxyHost, Integer repositoryProxyPort, boolean deleteStubsAfterTest, Map<String, String> contractsProperties, boolean failOnNoContracts) {
        this.project = project;
        this.contractDependency = contractDependency;
        this.contractsPath = contractsPath;
        this.contractsRepositoryUrl = contractsRepositoryUrl;
        this.stubsMode = stubsMode;
        this.log = log;
        this.repositoryUsername = repositoryUsername;
        this.repositoryPassword = repositoryPassword;
        this.repositoryProxyHost = repositoryProxyHost;
        this.repositoryProxyPort = repositoryProxyPort;
        this.stubDownloaderBuilderProvider = new StubDownloaderBuilderProvider();
        this.deleteStubsAfterTest = deleteStubsAfterTest;
        this.contractsProperties = contractsProperties;
        this.failOnNoStubs = failOnNoContracts;
    }

    File downloadAndUnpackContractsIfRequired(ContractVerifierConfigProperties config, File defaultContractsDir) {
        File downloadedContractsDir;
        String contractsDirFromProp = this.project.getProperties().getProperty(this.directoryProperty());
        File file = downloadedContractsDir = StringUtils.hasText((String)contractsDirFromProp) ? new File(contractsDirFromProp) : null;
        if (downloadedContractsDir != null && downloadedContractsDir.exists()) {
            this.log.info((CharSequence)("Another mojo has downloaded the contracts - will reuse them from [" + downloadedContractsDir + "]"));
            ContractDownloader.InclusionProperties inclusionProperties = this.contractDownloader().createNewInclusionProperties(downloadedContractsDir);
            config.setIncludedContracts(inclusionProperties.getIncludedContracts());
            config.setIncludedRootFolderAntPattern(inclusionProperties.getIncludedRootFolderAntPattern());
            return downloadedContractsDir;
        }
        if (this.shouldDownloadContracts()) {
            this.log.info((CharSequence)"Download dependency is provided - will retrieve contracts from a remote location");
            ContractDownloader contractDownloader = this.contractDownloader();
            File downloadedContracts = contractDownloader.unpackAndDownloadContracts();
            ContractDownloader.InclusionProperties inclusionProperties = contractDownloader.createNewInclusionProperties(downloadedContracts);
            config.setIncludedContracts(inclusionProperties.getIncludedContracts());
            config.setIncludedRootFolderAntPattern(inclusionProperties.getIncludedRootFolderAntPattern());
            this.project.getProperties().setProperty(this.directoryProperty(), downloadedContracts.getAbsolutePath());
            return downloadedContracts;
        }
        this.log.info((CharSequence)("Will use contracts provided in the folder [" + defaultContractsDir + "]"));
        return defaultContractsDir;
    }

    private String directoryProperty() {
        if (this.contractDependency == null) {
            return CONTRACTS_DIRECTORY_PROP;
        }
        return "CONTRACTS_DIRECTORY_" + this.contractDependency.getGroupId() + ":" + this.contractDependency.getArtifactId() + ":" + this.contractDependency.getVersion() + ":" + this.contractDependency.getClassifier();
    }

    private boolean shouldDownloadContracts() {
        return this.contractDependency != null && StringUtils.hasText((String)this.contractDependency.getArtifactId()) || StringUtils.hasText((String)this.contractsRepositoryUrl);
    }

    ContractDownloader contractDownloader() {
        return new ContractDownloader(this.stubDownloader(), this.stubConfiguration(), this.contractsPath, this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion());
    }

    private StubDownloader stubDownloader() {
        StubRunnerOptions stubRunnerOptions = this.buildOptions();
        return this.stubDownloaderBuilderProvider.get(stubRunnerOptions, new StubDownloaderBuilder[0]);
    }

    StubRunnerOptions buildOptions() {
        StubRunnerOptionsBuilder builder = new StubRunnerOptionsBuilder().withOptions(StubRunnerOptions.fromSystemProps()).withStubsMode(this.stubsMode).withUsername(this.repositoryUsername).withPassword(this.repositoryPassword).withDeleteStubsAfterTest(this.deleteStubsAfterTest).withProperties(this.contractsProperties).withFailOnNoStubs(this.failOnNoStubs);
        if (StringUtils.hasText((String)this.contractsRepositoryUrl)) {
            builder.withStubRepositoryRoot(this.contractsRepositoryUrl);
        }
        if (this.repositoryProxyPort != null) {
            builder.withProxy(this.repositoryProxyHost, this.repositoryProxyPort.intValue());
        }
        return builder.build();
    }

    private StubConfiguration stubConfiguration() {
        String groupId = this.contractDependency.getGroupId();
        String artifactId = this.contractDependency.getArtifactId();
        String version = StringUtils.hasText((String)this.contractDependency.getVersion()) ? this.contractDependency.getVersion() : LATEST_VERSION;
        String classifier = this.contractDependency.getClassifier();
        return new StubConfiguration(groupId, artifactId, version, classifier);
    }
}

