/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.spec.pact;

import au.com.dius.pact.core.model.DefaultPactReader;
import au.com.dius.pact.core.model.Pact;
import au.com.dius.pact.core.model.PactSpecVersion;
import au.com.dius.pact.core.model.RequestResponsePact;
import au.com.dius.pact.core.model.messaging.MessagePact;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.core.util.Separators;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.spec.ContractConverter;
import org.springframework.cloud.contract.verifier.spec.pact.MessagePactCreator;
import org.springframework.cloud.contract.verifier.spec.pact.MessagingSCContractCreator;
import org.springframework.cloud.contract.verifier.spec.pact.NamingUtil;
import org.springframework.cloud.contract.verifier.spec.pact.ObjectMapperFactory;
import org.springframework.cloud.contract.verifier.spec.pact.RequestResponsePactCreator;
import org.springframework.cloud.contract.verifier.spec.pact.RequestResponseSCContractCreator;

public class PactContractConverter
implements ContractConverter<Collection<Pact<?>>> {
    private static final ObjectMapper OBJECT_MAPPER = ObjectMapperFactory.INSTANCE.getMapper();
    private final RequestResponseSCContractCreator requestResponseSCContractCreator = new RequestResponseSCContractCreator();
    private final MessagingSCContractCreator messagingSCContractCreator = new MessagingSCContractCreator();
    private final RequestResponsePactCreator requestResponsePactCreator = new RequestResponsePactCreator();
    private final MessagePactCreator messagePactCreator = new MessagePactCreator();

    public boolean isAccepted(File file) {
        try {
            DefaultPactReader.INSTANCE.loadPact((Object)file);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Collection<Contract> convertFrom(File file) {
        Pact pact = DefaultPactReader.INSTANCE.loadPact((Object)file);
        if (pact instanceof RequestResponsePact) {
            return this.requestResponseSCContractCreator.convertFrom((RequestResponsePact)pact);
        }
        if (pact instanceof MessagePact) {
            return this.messagingSCContractCreator.convertFrom((MessagePact)pact);
        }
        throw new UnsupportedOperationException("We currently don't support pact contracts of type" + pact.getClass().getSimpleName());
    }

    public Collection<Pact<?>> convertTo(Collection<Contract> contracts) {
        ArrayList pactContracts = new ArrayList();
        Map<String, List<Contract>> groupedContracts = contracts.stream().collect(Collectors.groupingBy(c -> NamingUtil.name(c).toString()));
        for (List<Contract> list : groupedContracts.values()) {
            MessagePact messagePact;
            List<Contract> httpOnly = list.stream().filter(c -> c.getRequest() != null).collect(Collectors.toList());
            List<Contract> messagingOnly = list.stream().filter(c -> c.getInput() != null).collect(Collectors.toList());
            RequestResponsePact responsePact = this.requestResponsePactCreator.createFromContract(httpOnly);
            if (responsePact != null) {
                pactContracts.add((Pact<?>)responsePact);
            }
            if ((messagePact = this.messagePactCreator.createFromContract(messagingOnly)) == null) continue;
            pactContracts.add((Pact<?>)messagePact);
        }
        return pactContracts;
    }

    public Map<String, byte[]> store(Collection<Pact<?>> contracts) {
        return contracts.stream().collect(Collectors.toMap(this::name, c -> {
            try {
                return this.buildPrettyPrint(OBJECT_MAPPER.writeValueAsString((Object)c.toMap(PactSpecVersion.V3))).getBytes();
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException("The pact contract is not a valid map", e);
            }
        }));
    }

    protected String name(Pact<?> contract) {
        return contract.getConsumer().getName() + "_" + contract.getProvider().getName() + "_" + Math.abs(contract.hashCode()) + ".json";
    }

    private String buildPrettyPrint(String contract) {
        try {
            Object intermediateObjectForPrettyPrinting = OBJECT_MAPPER.reader().readValue(contract, Object.class);
            DefaultIndenter customIndenter = new DefaultIndenter("    ", "\n");
            return OBJECT_MAPPER.writer((PrettyPrinter)new CustomPrettyPrinter().withArrayIndenter((DefaultPrettyPrinter.Indenter)customIndenter).withObjectIndenter((DefaultPrettyPrinter.Indenter)customIndenter)).writeValueAsString(intermediateObjectForPrettyPrinting);
        }
        catch (IOException e) {
            throw new RuntimeException("WireMock response body could not be pretty printed");
        }
    }

    private static class CustomPrettyPrinter
    extends DefaultPrettyPrinter {
        private CustomPrettyPrinter() {
        }

        public CustomPrettyPrinter createInstance() {
            return new CustomPrettyPrinter();
        }

        public DefaultPrettyPrinter withSeparators(Separators separators) {
            this._separators = separators;
            this._objectFieldValueSeparatorWithSpaces = separators.getObjectFieldValueSeparator() + " ";
            return this;
        }
    }
}

