/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.spec.pact;

import au.com.dius.pact.core.model.OptionalBody;
import au.com.dius.pact.core.model.ProviderState;
import au.com.dius.pact.core.model.RequestResponseInteraction;
import au.com.dius.pact.core.model.RequestResponsePact;
import au.com.dius.pact.core.model.Response;
import au.com.dius.pact.core.model.matchingrules.Category;
import au.com.dius.pact.core.model.matchingrules.DateMatcher;
import au.com.dius.pact.core.model.matchingrules.MatchingRule;
import au.com.dius.pact.core.model.matchingrules.MatchingRuleGroup;
import au.com.dius.pact.core.model.matchingrules.MaxTypeMatcher;
import au.com.dius.pact.core.model.matchingrules.MinMaxTypeMatcher;
import au.com.dius.pact.core.model.matchingrules.MinTypeMatcher;
import au.com.dius.pact.core.model.matchingrules.NullMatcher;
import au.com.dius.pact.core.model.matchingrules.NumberTypeMatcher;
import au.com.dius.pact.core.model.matchingrules.RegexMatcher;
import au.com.dius.pact.core.model.matchingrules.RuleLogic;
import au.com.dius.pact.core.model.matchingrules.TimeMatcher;
import au.com.dius.pact.core.model.matchingrules.TimestampMatcher;
import au.com.dius.pact.core.model.matchingrules.TypeMatcher;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.MapUtils;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.spec.internal.MatchingTypeValue;
import org.springframework.cloud.contract.spec.internal.RegexPatterns;
import org.springframework.cloud.contract.spec.internal.Request;
import org.springframework.cloud.contract.verifier.spec.pact.BodyConverter;
import org.springframework.cloud.contract.verifier.util.JsonPaths;
import org.springframework.cloud.contract.verifier.util.JsonToJsonPathsConverter;

class RequestResponseSCContractCreator {
    private static final String FULL_BODY = "$";

    RequestResponseSCContractCreator() {
    }

    Collection<Contract> convertFrom(RequestResponsePact pact) {
        return pact.getInteractions().stream().map(interaction -> Contract.make(contract -> {
            this.mapContractDescription((RequestResponseInteraction)interaction, (Contract)contract);
            this.mapContractRequest((RequestResponseInteraction)interaction, (Contract)contract);
            this.mapContractResponse((RequestResponseInteraction)interaction, (Contract)contract);
        })).collect(Collectors.toList());
    }

    private void mapContractDescription(RequestResponseInteraction interaction, Contract contract) {
        contract.description(this.buildDescription(interaction));
    }

    private void mapContractRequest(RequestResponseInteraction interaction, Contract contract) {
        contract.request(contractRequest -> {
            Category bodyRules;
            au.com.dius.pact.core.model.Request pactRequest = interaction.getRequest();
            contractRequest.method(pactRequest.getMethod());
            this.mapRequestUrl((Request)contractRequest, pactRequest);
            if (MapUtils.isNotEmpty((Map)pactRequest.getHeaders())) {
                this.mapRequestHeaders((Request)contractRequest, pactRequest);
            }
            if (pactRequest.getHeaders().containsKey("Cookie")) {
                this.mapRequestCookies((Request)contractRequest, pactRequest);
            }
            if (pactRequest.getBody().getState() == OptionalBody.State.PRESENT) {
                this.mapRequestBody((Request)contractRequest, pactRequest);
            }
            if (MapUtils.isNotEmpty((Map)(bodyRules = pactRequest.getMatchingRules().rulesForCategory("body")).getMatchingRules())) {
                this.mapRequestBodyRules((Request)contractRequest, bodyRules);
            }
        });
    }

    private void mapContractResponse(RequestResponseInteraction interaction, Contract contract) {
        contract.response(contractResponse -> {
            Category bodyRules;
            Response pactResponse = interaction.getResponse();
            contractResponse.status(pactResponse.getStatus());
            if (pactResponse.getBody().isPresent()) {
                this.mapResponseBody((org.springframework.cloud.contract.spec.internal.Response)contractResponse, pactResponse);
            }
            if (MapUtils.isNotEmpty((Map)(bodyRules = pactResponse.getMatchingRules().rulesForCategory("body")).getMatchingRules())) {
                this.mapResponseBodyRules((org.springframework.cloud.contract.spec.internal.Response)contractResponse, pactResponse, bodyRules);
            }
            if (MapUtils.isNotEmpty((Map)pactResponse.getHeaders())) {
                this.mapResponseHeaders((org.springframework.cloud.contract.spec.internal.Response)contractResponse, pactResponse);
            }
            if (pactResponse.getHeaders().containsKey("Cookie")) {
                this.mapResponseCookies((org.springframework.cloud.contract.spec.internal.Response)contractResponse, pactResponse);
            }
        });
    }

    private void mapResponseBodyRules(org.springframework.cloud.contract.spec.internal.Response contractResponse, Response pactResponse, Category bodyRules) {
        contractResponse.bodyMatchers(bodyMatchers -> bodyRules.getMatchingRules().forEach((key, matchindRuleGroup) -> {
            if (matchindRuleGroup.getRuleLogic() != RuleLogic.AND) {
                throw new UnsupportedOperationException("Currently only the AND combination rule logic is supported");
            }
            if (FULL_BODY.equals(key)) {
                JsonPaths jsonPaths = JsonToJsonPathsConverter.transformToJsonPathWithStubsSideValuesAndNoArraySizeCheck((Object)new String(pactResponse.getBody().getValue()));
                jsonPaths.forEach(jsonPath -> bodyMatchers.jsonPath(jsonPath.keyBeforeChecking(), bodyMatchers.byType()));
            } else {
                matchindRuleGroup.getRules().forEach(matchingRule -> {
                    if (matchingRule instanceof NullMatcher) {
                        bodyMatchers.jsonPath(key, bodyMatchers.byNull());
                    } else if (matchingRule instanceof RegexMatcher) {
                        bodyMatchers.jsonPath(key, (MatchingTypeValue)bodyMatchers.byRegex(((RegexMatcher)matchingRule).getRegex()));
                    } else if (matchingRule instanceof DateMatcher) {
                        bodyMatchers.jsonPath(key, bodyMatchers.byDate());
                    } else if (matchingRule instanceof TimeMatcher) {
                        bodyMatchers.jsonPath(key, bodyMatchers.byTime());
                    } else if (matchingRule instanceof TimestampMatcher) {
                        bodyMatchers.jsonPath(key, bodyMatchers.byTimestamp());
                    } else if (matchingRule instanceof MinTypeMatcher) {
                        bodyMatchers.jsonPath(key, bodyMatchers.byType(valueHolder -> valueHolder.minOccurrence(((MinTypeMatcher)matchingRule).getMin())));
                    } else if (matchingRule instanceof MinMaxTypeMatcher) {
                        bodyMatchers.jsonPath(key, bodyMatchers.byType(valueHolder -> {
                            valueHolder.minOccurrence(((MinMaxTypeMatcher)matchingRule).getMin());
                            valueHolder.maxOccurrence(((MinMaxTypeMatcher)matchingRule).getMax());
                        }));
                    } else if (matchingRule instanceof MaxTypeMatcher) {
                        bodyMatchers.jsonPath(key, bodyMatchers.byType(valueHolder -> valueHolder.maxOccurrence(((MaxTypeMatcher)matchingRule).getMax())));
                    } else if (matchingRule instanceof TypeMatcher) {
                        bodyMatchers.jsonPath(key, bodyMatchers.byType());
                    } else if (matchingRule instanceof NumberTypeMatcher) {
                        switch (((NumberTypeMatcher)matchingRule).getNumberType()) {
                            case NUMBER: {
                                bodyMatchers.jsonPath(key, (MatchingTypeValue)bodyMatchers.byRegex(RegexPatterns.number()));
                                break;
                            }
                            case INTEGER: {
                                bodyMatchers.jsonPath(key, (MatchingTypeValue)bodyMatchers.byRegex(RegexPatterns.anInteger()));
                                break;
                            }
                            case DECIMAL: {
                                bodyMatchers.jsonPath(key, (MatchingTypeValue)bodyMatchers.byRegex(RegexPatterns.aDouble()));
                                break;
                            }
                            default: {
                                throw new UnsupportedOperationException("Unsupported number type!");
                            }
                        }
                    }
                });
            }
        }));
    }

    private void mapResponseBody(org.springframework.cloud.contract.spec.internal.Response contractResponse, Response pactResponse) {
        Object parsedBody = BodyConverter.toSCCBody(pactResponse);
        if (parsedBody instanceof Map) {
            contractResponse.body((Map)parsedBody);
        } else if (parsedBody instanceof List) {
            contractResponse.body((List)parsedBody);
        } else {
            contractResponse.body((Object)parsedBody.toString());
        }
    }

    private void mapRequestBodyRules(Request contractRequest, Category bodyRules) {
        contractRequest.bodyMatchers(bodyMatchers -> bodyRules.getMatchingRules().forEach((key, matchingRuleGroup) -> {
            if (matchingRuleGroup.getRuleLogic() != RuleLogic.AND) {
                throw new UnsupportedOperationException("Currently only the AND combination rule logic is supported");
            }
            matchingRuleGroup.getRules().forEach(matchingRule -> {
                if (matchingRule instanceof RegexMatcher) {
                    bodyMatchers.jsonPath(key, (MatchingTypeValue)bodyMatchers.byRegex(((RegexMatcher)matchingRule).getRegex()));
                } else if (matchingRule instanceof DateMatcher) {
                    bodyMatchers.jsonPath(key, bodyMatchers.byDate());
                } else if (matchingRule instanceof TimeMatcher) {
                    bodyMatchers.jsonPath(key, bodyMatchers.byTime());
                } else if (matchingRule instanceof TimestampMatcher) {
                    bodyMatchers.jsonPath(key, bodyMatchers.byTimestamp());
                } else if (matchingRule instanceof NumberTypeMatcher) {
                    switch (((NumberTypeMatcher)matchingRule).getNumberType()) {
                        case NUMBER: {
                            bodyMatchers.jsonPath(key, (MatchingTypeValue)bodyMatchers.byRegex(RegexPatterns.number()));
                            break;
                        }
                        case INTEGER: {
                            bodyMatchers.jsonPath(key, (MatchingTypeValue)bodyMatchers.byRegex(RegexPatterns.anInteger()));
                            break;
                        }
                        case DECIMAL: {
                            bodyMatchers.jsonPath(key, (MatchingTypeValue)bodyMatchers.byRegex(RegexPatterns.aDouble()));
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unsupported number type!");
                        }
                    }
                }
            });
        }));
    }

    private void mapRequestBody(Request contractRequest, au.com.dius.pact.core.model.Request pactRequest) {
        Object parsedBody = BodyConverter.toSCCBody(pactRequest);
        if (parsedBody instanceof Map) {
            contractRequest.body((Map)parsedBody);
        } else if (parsedBody instanceof List) {
            contractRequest.body((List)parsedBody);
        } else {
            contractRequest.body((Object)parsedBody.toString());
        }
    }

    private void mapRequestCookies(Request contractRequest, au.com.dius.pact.core.model.Request pactRequest) {
        Category headerRules = pactRequest.getMatchingRules().rulesForCategory("header");
        String[] splitCookiesHeader = ((String)((List)pactRequest.getHeaders().get("Cookie")).get(0)).split(";");
        Map<String, String> foundCookies = Stream.of(splitCookiesHeader).map(cookieHeader -> cookieHeader.split("=")).collect(Collectors.toMap(splittedCookieHeader -> splittedCookieHeader[0], splittedCookieHeader -> splittedCookieHeader[1]));
        contractRequest.cookies(cookies -> foundCookies.forEach((key, value) -> {
            if (headerRules.getMatchingRules().containsKey("Cookie")) {
                MatchingRuleGroup matchingRuleGroup = (MatchingRuleGroup)headerRules.getMatchingRules().get("Cookie");
                if (matchingRuleGroup.getRules().size() > 1) {
                    throw new UnsupportedOperationException("Currently only 1 rule at a time for a header is supported");
                }
                MatchingRule matchingRule = (MatchingRule)matchingRuleGroup.getRules().get(0);
                if (!(matchingRule instanceof RegexMatcher)) throw new UnsupportedOperationException("Currently only the header matcher of type regex is supported");
                cookies.cookie(key, (Object)contractRequest.$(contractRequest.c((Object)contractRequest.regex(((RegexMatcher)matchingRule).getRegex())), contractRequest.p(value)));
                return;
            } else {
                cookies.cookie(key, value);
            }
        }));
    }

    private void mapResponseCookies(org.springframework.cloud.contract.spec.internal.Response contractResponse, Response pactResponse) {
        Category headerRules = pactResponse.getMatchingRules().rulesForCategory("header");
        String[] splitCookiesHeader = ((String)((List)pactResponse.getHeaders().get("Cookie")).get(0)).split(";");
        Map<String, String> foundCookies = Stream.of(splitCookiesHeader).map(cookieHeader -> cookieHeader.split("=")).collect(Collectors.toMap(splittedCookieHeader -> splittedCookieHeader[0], splittedCookieHeader -> splittedCookieHeader[1]));
        contractResponse.cookies(cookies -> foundCookies.forEach((key, value) -> {
            if (headerRules.getMatchingRules().containsKey("Cookie")) {
                MatchingRuleGroup matchingRuleGroup = (MatchingRuleGroup)headerRules.getMatchingRules().get("Cookie");
                if (matchingRuleGroup.getRules().size() > 1) {
                    throw new UnsupportedOperationException("Currently only 1 rule at a time for a header is supported");
                }
                MatchingRule matchingRule = (MatchingRule)matchingRuleGroup.getRules().get(0);
                if (!(matchingRule instanceof RegexMatcher)) throw new UnsupportedOperationException("Currently only the header matcher of type regex is supported");
                cookies.cookie(key, (Object)contractResponse.$(contractResponse.p((Object)contractResponse.regex(Pattern.compile(((RegexMatcher)matchingRule).getRegex()))), contractResponse.c(value)));
                return;
            } else {
                cookies.cookie(key, value);
            }
        }));
    }

    private void mapRequestUrl(Request contractRequest, au.com.dius.pact.core.model.Request pactRequest) {
        if (MapUtils.isNotEmpty((Map)pactRequest.getQuery())) {
            contractRequest.url((Object)pactRequest.getPath(), url -> url.queryParameters(queryParameters -> pactRequest.getQuery().forEach((key, values) -> values.forEach(singleValue -> queryParameters.parameter(key, singleValue)))));
        } else {
            contractRequest.url((Object)pactRequest.getPath());
        }
    }

    private void mapRequestHeaders(Request contractRequest, au.com.dius.pact.core.model.Request pactRequest) {
        Category headerRules = pactRequest.getMatchingRules().rulesForCategory("header");
        contractRequest.headers(headers -> pactRequest.getHeaders().forEach((key, values) -> {
            if (key.equalsIgnoreCase("Cookie")) {
                return;
            }
            if (headerRules.getMatchingRules().containsKey(key)) {
                MatchingRuleGroup matchingRuleGroup = (MatchingRuleGroup)headerRules.getMatchingRules().get(key);
                if (matchingRuleGroup.getRules().size() > 1) {
                    throw new UnsupportedOperationException("Currently only 1 rule at a time for a header is supported");
                }
                MatchingRule matchingRule = (MatchingRule)matchingRuleGroup.getRules().get(0);
                if (!(matchingRule instanceof RegexMatcher)) throw new UnsupportedOperationException("Currently only the header matcher of type regex is supported");
                values.forEach(value -> headers.header(key, (Object)contractRequest.$(contractRequest.c((Object)contractRequest.regex(((RegexMatcher)matchingRule).getRegex())), contractRequest.p(value))));
                return;
            } else {
                values.forEach(value -> headers.header(key, value));
            }
        }));
    }

    private void mapResponseHeaders(org.springframework.cloud.contract.spec.internal.Response contractResponse, Response pactResponse) {
        Category headerRules = pactResponse.getMatchingRules().rulesForCategory("header");
        contractResponse.headers(headers -> pactResponse.getHeaders().forEach((key, values) -> {
            if (key.equalsIgnoreCase("Cookie")) {
                return;
            }
            if (headerRules.getMatchingRules().containsKey(key)) {
                MatchingRuleGroup matchingRuleGroup = (MatchingRuleGroup)headerRules.getMatchingRules().get(key);
                if (matchingRuleGroup.getRules().size() > 1) {
                    throw new UnsupportedOperationException("Currently only 1 rule at a time for a header is supported");
                }
                MatchingRule matchingRule = (MatchingRule)matchingRuleGroup.getRules().get(0);
                if (!(matchingRule instanceof RegexMatcher)) throw new UnsupportedOperationException("Currently only the header matcher of type regex is supported");
                values.forEach(value -> headers.header(key, (Object)contractResponse.$(contractResponse.p((Object)contractResponse.regex(Pattern.compile(((RegexMatcher)matchingRule).getRegex()))), contractResponse.c(value))));
                return;
            } else {
                values.forEach(value -> headers.header(key, value));
            }
        }));
    }

    private String buildDescription(RequestResponseInteraction interaction) {
        StringBuilder description = new StringBuilder(interaction.getDescription());
        List providerStates = interaction.getProviderStates();
        for (ProviderState providerState : providerStates) {
            description.append(" ").append(providerState.getName());
            Map params = providerState.getParams();
            if (!MapUtils.isNotEmpty((Map)params)) continue;
            description.append("(");
            params.forEach((k, v) -> description.append((String)k).append(": ").append(v.toString()).append(", "));
            description.delete(description.length() - 2, description.length());
            description.append(")");
        }
        return description.toString();
    }
}

