/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.maven.repository.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.metadata.Metadata;
import shaded.org.apache.maven.artifact.repository.metadata.Metadata;
import shaded.org.apache.maven.artifact.repository.metadata.Plugin;
import shaded.org.apache.maven.artifact.repository.metadata.Snapshot;
import shaded.org.apache.maven.artifact.repository.metadata.SnapshotVersion;
import shaded.org.apache.maven.artifact.repository.metadata.Versioning;
import shaded.org.apache.maven.repository.internal.MavenMetadata;

final class LocalSnapshotMetadata
extends MavenMetadata {
    private final Collection<Artifact> artifacts = new ArrayList<Artifact>();
    private final boolean legacyFormat;

    LocalSnapshotMetadata(Artifact artifact, boolean legacyFormat, Date timestamp) {
        super(LocalSnapshotMetadata.createMetadata(artifact, legacyFormat), null, timestamp);
        this.legacyFormat = legacyFormat;
    }

    LocalSnapshotMetadata(Metadata metadata, File file, boolean legacyFormat, Date timestamp) {
        super(metadata, file, timestamp);
        this.legacyFormat = legacyFormat;
    }

    private static Metadata createMetadata(Artifact artifact, boolean legacyFormat) {
        Snapshot snapshot = new Snapshot();
        snapshot.setLocalCopy(true);
        Versioning versioning = new Versioning();
        versioning.setSnapshot(snapshot);
        Metadata metadata = new Metadata();
        metadata.setVersioning(versioning);
        metadata.setGroupId(artifact.getGroupId());
        metadata.setArtifactId(artifact.getArtifactId());
        metadata.setVersion(artifact.getBaseVersion());
        if (!legacyFormat) {
            metadata.setModelVersion("1.1.0");
        }
        return metadata;
    }

    public void bind(Artifact artifact) {
        this.artifacts.add(artifact);
    }

    @Override
    public MavenMetadata setFile(File file) {
        return new LocalSnapshotMetadata(this.metadata, file, this.legacyFormat, this.timestamp);
    }

    public Object getKey() {
        return this.getGroupId() + ':' + this.getArtifactId() + ':' + this.getVersion();
    }

    public static Object getKey(Artifact artifact) {
        return artifact.getGroupId() + ':' + artifact.getArtifactId() + ':' + artifact.getBaseVersion();
    }

    @Override
    protected void merge(Metadata recessive) {
        this.metadata.getVersioning().setLastUpdatedTimestamp(this.timestamp);
        if (!this.legacyFormat) {
            String lastUpdated = this.metadata.getVersioning().getLastUpdated();
            LinkedHashMap<String, SnapshotVersion> versions = new LinkedHashMap<String, SnapshotVersion>();
            for (Artifact artifact : this.artifacts) {
                SnapshotVersion sv = new SnapshotVersion();
                sv.setClassifier(artifact.getClassifier());
                sv.setExtension(artifact.getExtension());
                sv.setVersion(this.getVersion());
                sv.setUpdated(lastUpdated);
                versions.put(this.getKey(sv.getClassifier(), sv.getExtension()), sv);
            }
            Versioning versioning = recessive.getVersioning();
            if (versioning != null) {
                for (SnapshotVersion sv : versioning.getSnapshotVersions()) {
                    String key = this.getKey(sv.getClassifier(), sv.getExtension());
                    if (versions.containsKey(key)) continue;
                    versions.put(key, sv);
                }
            }
            this.metadata.getVersioning().setSnapshotVersions(new ArrayList<SnapshotVersion>(versions.values()));
        }
        if (!recessive.getPlugins().isEmpty()) {
            this.metadata.setPlugins(new ArrayList<Plugin>(recessive.getPlugins()));
        }
        this.artifacts.clear();
    }

    private String getKey(String classifier, String extension) {
        return classifier + ':' + extension;
    }

    @Override
    public String getGroupId() {
        return this.metadata.getGroupId();
    }

    @Override
    public String getArtifactId() {
        return this.metadata.getArtifactId();
    }

    @Override
    public String getVersion() {
        return this.metadata.getVersion();
    }

    @Override
    public Metadata.Nature getNature() {
        return Metadata.Nature.SNAPSHOT;
    }
}

