/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.aether.internal.impl;

import java.util.Objects;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.metadata.Metadata;
import shaded.org.eclipse.aether.internal.impl.LocalPathComposer;

@Singleton
@Named
public final class DefaultLocalPathComposer
implements LocalPathComposer {
    @Override
    public String getPathForArtifact(Artifact artifact, boolean local) {
        Objects.requireNonNull(artifact);
        StringBuilder path = new StringBuilder(128);
        path.append(artifact.getGroupId().replace('.', '/')).append('/');
        path.append(artifact.getArtifactId()).append('/');
        path.append(artifact.getBaseVersion()).append('/');
        path.append(artifact.getArtifactId()).append('-');
        if (local) {
            path.append(artifact.getBaseVersion());
        } else {
            path.append(artifact.getVersion());
        }
        if (artifact.getClassifier().length() > 0) {
            path.append('-').append(artifact.getClassifier());
        }
        if (artifact.getExtension().length() > 0) {
            path.append('.').append(artifact.getExtension());
        }
        return path.toString();
    }

    @Override
    public String getPathForMetadata(Metadata metadata, String repositoryKey) {
        Objects.requireNonNull(metadata);
        Objects.requireNonNull(repositoryKey);
        StringBuilder path = new StringBuilder(128);
        if (metadata.getGroupId().length() > 0) {
            path.append(metadata.getGroupId().replace('.', '/')).append('/');
            if (metadata.getArtifactId().length() > 0) {
                path.append(metadata.getArtifactId()).append('/');
                if (metadata.getVersion().length() > 0) {
                    path.append(metadata.getVersion()).append('/');
                }
            }
        }
        path.append(this.insertRepositoryKey(metadata.getType(), repositoryKey));
        return path.toString();
    }

    private String insertRepositoryKey(String metadataType, String repositoryKey) {
        int idx = metadataType.indexOf(46);
        String result = idx < 0 ? metadataType + '-' + repositoryKey : metadataType.substring(0, idx) + '-' + repositoryKey + metadataType.substring(idx);
        return result;
    }
}

