/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.spec.internal;

import java.io.Serializable;
import java.util.regex.Pattern;
import org.springframework.cloud.contract.spec.internal.CanBeDynamic;
import org.springframework.cloud.contract.spec.internal.ClientDslProperty;
import org.springframework.cloud.contract.spec.internal.RegexProperty;
import repackaged.nl.flotsam.xeger.Xeger;

public class OptionalProperty
implements Serializable,
CanBeDynamic {
    private final Object value;

    public OptionalProperty(Object value) {
        this.value = value;
    }

    public String optionalPattern() {
        return "(" + this.value() + ")?";
    }

    public String value() {
        return this.valueToCheck(this.value).toString();
    }

    private Object valueToCheck(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof ClientDslProperty) {
            return this.valueToCheck(((ClientDslProperty)value).getClientValue());
        }
        if (value instanceof RegexProperty || value instanceof Pattern) {
            return new RegexProperty(value).pattern();
        }
        return value.toString();
    }

    protected Pattern optionalPatternValue() {
        return Pattern.compile(this.optionalPattern());
    }

    public String toString() {
        return this.optionalPattern();
    }

    @Override
    public Object generateConcreteValue() {
        return new Xeger(this.optionalPattern()).generate();
    }

    public final Object getValue() {
        return this.value;
    }
}

