/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.spec.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.springframework.cloud.contract.spec.internal.ContractUtils;
import org.springframework.cloud.contract.spec.internal.Cookie;
import org.springframework.cloud.contract.spec.internal.DslProperty;

public class Cookies {
    private Set<Cookie> entries = new HashSet<Cookie>();

    public void cookie(Map<String, Object> singleCookie) {
        Map.Entry<String, Object> first;
        Iterator<Map.Entry<String, Object>> iterator = singleCookie.entrySet().iterator();
        if (iterator.hasNext() && (first = iterator.next()) != null) {
            this.entries.add(Cookie.build(first.getKey(), first.getValue()));
        }
    }

    public void cookie(String cookieKey, Object cookieValue) {
        this.entries.add(Cookie.build(cookieKey, cookieValue));
    }

    public void executeForEachCookie(Consumer<Cookie> consumer) {
        this.entries.forEach(consumer::accept);
    }

    public DslProperty matching(String value) {
        return new DslProperty<String>(value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cookies cookies = (Cookies)o;
        return Objects.equals(this.entries, cookies.entries);
    }

    public int hashCode() {
        return Objects.hash(this.entries);
    }

    public String toString() {
        return "Cookies{entries=" + this.entries + '}';
    }

    public Map<String, Object> asStubSideMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        this.entries.forEach(cookie -> map.put(cookie.getKey(), ContractUtils.convertStubSideRecursively(cookie)));
        return map;
    }

    public Map<String, Object> asTestSideMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.entries.forEach(cookie -> map.put(cookie.getKey(), ContractUtils.convertTestSideRecursively(cookie)));
        return map;
    }

    public Set<Cookie> getEntries() {
        return this.entries;
    }

    public void setEntries(Set<Cookie> entries) {
        this.entries = entries;
    }
}

