/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.spec.internal;

import java.util.Map;
import java.util.Objects;
import org.springframework.cloud.contract.spec.internal.DslProperty;

public class NamedProperty {
    private static final String NAME = "name";
    private static final String CONTENT = "content";
    private static final String CONTENT_TYPE = "contentType";
    private DslProperty name;
    private DslProperty value;
    private DslProperty contentType;

    public NamedProperty(DslProperty name, DslProperty value) {
        this.name = name;
        this.value = value;
        this.contentType = null;
    }

    public NamedProperty(DslProperty name, DslProperty value, DslProperty contentType) {
        this.name = name;
        this.value = value;
        this.contentType = contentType;
    }

    public NamedProperty(Map<String, DslProperty> namedMap) {
        this(NamedProperty.asDslProperty(NamedProperty.value(namedMap, NAME)), NamedProperty.asDslProperty(NamedProperty.value(namedMap, CONTENT)), NamedProperty.asDslProperty(NamedProperty.value(namedMap, CONTENT_TYPE)));
    }

    private static DslProperty value(Map<String, DslProperty> namedMap, String key) {
        if (namedMap == null) {
            return null;
        }
        return namedMap.get(key);
    }

    public static DslProperty asDslProperty(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof DslProperty) {
            return (DslProperty)o;
        }
        return new DslProperty<Object>(o);
    }

    public DslProperty getName() {
        return this.name;
    }

    public void setName(DslProperty name) {
        this.name = name;
    }

    public DslProperty getValue() {
        return this.value;
    }

    public void setValue(DslProperty value) {
        this.value = value;
    }

    public DslProperty getContentType() {
        return this.contentType;
    }

    public void setContentType(DslProperty contentType) {
        this.contentType = contentType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamedProperty that = (NamedProperty)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value) && Objects.equals(this.contentType, that.contentType);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value, this.contentType);
    }

    public String toString() {
        return "NamedProperty{name=" + this.name + ", value=" + this.value + ", contentType=" + this.contentType + '}';
    }
}

