/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.spec.internal;

import java.util.function.Function;
import org.springframework.cloud.contract.spec.internal.DslProperty;

final class ContractUtils {
    static final Function CLIENT_VALUE = o -> o instanceof DslProperty ? ((DslProperty)o).getClientValue() : o;
    static final Function SERVER_VALUE = o -> o instanceof DslProperty ? ((DslProperty)o).getServerValue() : o;

    private ContractUtils() {
        throw new IllegalStateException("Can't instantiate an utility class");
    }

    static Object convertStubSideRecursively(Object object) {
        return ContractUtils.convertRecursively(object, CLIENT_VALUE);
    }

    static Object convertTestSideRecursively(Object object) {
        return ContractUtils.convertRecursively(object, SERVER_VALUE);
    }

    private static Object convertRecursively(Object object, Function function) {
        if (object instanceof DslProperty) {
            return ContractUtils.convertRecursively(function.apply(object), function);
        }
        return object;
    }
}

