/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.spec.internal;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.util.regex.Pattern;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;

public class RegexPatterns
implements GroovyObject {
    private static final Pattern TRUE_OR_FALSE;
    private static final Pattern ONLY_ALPHA_UNICODE;
    private static final Pattern NUMBER;
    private static final Pattern IP_ADDRESS;
    private static final Pattern HOSTNAME_PATTERN;
    private static final Pattern EMAIL;
    private static final Pattern URL;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public RegexPatterns() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public String onlyAlphaUnicode() {
        return ONLY_ALPHA_UNICODE.pattern();
    }

    public String number() {
        return NUMBER.pattern();
    }

    public String anyBoolean() {
        return TRUE_OR_FALSE.pattern();
    }

    public String ipAddress() {
        return IP_ADDRESS.pattern();
    }

    public String hostname() {
        return HOSTNAME_PATTERN.pattern();
    }

    public String email() {
        return EMAIL.pattern();
    }

    public String url() {
        return URL.pattern();
    }

    public static String multipartParam(Object name, Object value) {
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name, value}, new String[]{".*--(.*)\r\nContent-Disposition: form-data; name=\"", "\"\r\n(Content-Type: .*\r\n)?(Content-Length: \\d+\r\n)?\r\n", "\r\n--\\1.*"}));
    }

    public static String multipartFile(Object name, Object filename, Object content) {
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name, filename, content}, new String[]{".*--(.*)\r\nContent-Disposition: form-data; name=\"", "\"; filename=\"", "\"\r\n(Content-Type: .*\r\n)?(Content-Length: \\d+\r\n)?\r\n", "\r\n--\\1.*"}));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != RegexPatterns.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Pattern pattern;
        Pattern pattern2;
        Pattern pattern3;
        Pattern pattern4;
        Pattern pattern5;
        Pattern pattern6;
        Pattern pattern7;
        TRUE_OR_FALSE = pattern7 = Pattern.compile("(true|false)");
        ONLY_ALPHA_UNICODE = pattern6 = Pattern.compile("[\\p{L}]*");
        NUMBER = pattern5 = Pattern.compile("-?\\d*(\\.\\d+)?");
        IP_ADDRESS = pattern4 = Pattern.compile("([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])");
        HOSTNAME_PATTERN = pattern3 = Pattern.compile("((http[s]?|ftp):\\/)\\/?([^:\\/\\s]+)(:[0-9]{1,5})?");
        EMAIL = pattern2 = Pattern.compile("[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,4}");
        URL = pattern = Pattern.compile("((www\\.|(http|https|ftp|news|file)+\\:\\/\\/)[_.a-z0-9-]+\\.[a-z0-9\\/_:@=.+?,##%&~-]*[^.|\\'|\\# |!|\\(|?|,| |>|<|;|\\)])");
    }
}

