/*
 * Copyright 2013-2019 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.cloud.contract.spec.internal

import groovy.transform.CompileStatic
import groovy.transform.EqualsAndHashCode
import groovy.transform.ToString

/**
 * Contains most commonly used messaging headers
 *
 * @author Marcin Grzejszczak
 * @since 1.1.2
 */
@CompileStatic
@EqualsAndHashCode
@ToString(includePackage = false)
class MessagingHeaders {

	/**
	 * The Content Type of a message
	 * @return
	 */
	String messagingContentType() {
		return "contentType"
	}
}
