/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.stubrunner.Arguments;
import org.springframework.cloud.contract.stubrunner.AvailablePortScanner;
import org.springframework.cloud.contract.stubrunner.RunningStubs;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;
import org.springframework.cloud.contract.stubrunner.StubRepository;
import org.springframework.cloud.contract.stubrunner.StubRunnerExecutor;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptions;
import org.springframework.cloud.contract.stubrunner.StubRunning;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifier;
import org.springframework.cloud.contract.verifier.messaging.noop.NoOpStubMessages;

public class StubRunner
implements StubRunning {
    private final StubRepository stubRepository;
    private final StubConfiguration stubsConfiguration;
    private final StubRunnerOptions stubRunnerOptions;
    private final StubRunnerExecutor localStubRunner;

    @Deprecated
    StubRunner(Arguments arguments) {
        this(arguments.getStubRunnerOptions(), arguments.getRepositoryPath(), arguments.getStub());
    }

    public StubRunner(StubRunnerOptions stubRunnerOptions, String repositoryPath, StubConfiguration stubsConfiguration) {
        this(stubRunnerOptions, repositoryPath, stubsConfiguration, (MessageVerifier<?>)new NoOpStubMessages());
    }

    public StubRunner(StubRunnerOptions stubRunnerOptions, String repositoryPath, StubConfiguration stubsConfiguration, MessageVerifier<?> contractVerifierMessaging) {
        this.stubsConfiguration = stubsConfiguration;
        this.stubRunnerOptions = stubRunnerOptions;
        this.stubRepository = new StubRepository(new File(repositoryPath));
        AvailablePortScanner portScanner = new AvailablePortScanner(stubRunnerOptions.getMinPortValue(), stubRunnerOptions.getMaxPortValue());
        this.localStubRunner = new StubRunnerExecutor(portScanner, contractVerifierMessaging);
    }

    @Override
    public RunningStubs runStubs() {
        this.registerShutdownHook();
        return this.localStubRunner.runStubs(this.stubRunnerOptions, this.stubRepository, this.stubsConfiguration);
    }

    @Override
    public URL findStubUrl(String groupId, String artifactId) {
        return this.localStubRunner.findStubUrl(groupId, artifactId);
    }

    @Override
    public URL findStubUrl(String ivyNotation) {
        return this.localStubRunner.findStubUrl(ivyNotation);
    }

    @Override
    public RunningStubs findAllRunningStubs() {
        return this.localStubRunner.findAllRunningStubs();
    }

    @Override
    public Map<StubConfiguration, Collection<Contract>> getContracts() {
        return this.localStubRunner.getContracts();
    }

    @Override
    public boolean trigger(String ivyNotation, String labelName) {
        return this.localStubRunner.trigger(ivyNotation, labelName);
    }

    @Override
    public boolean trigger(String labelName) {
        return this.localStubRunner.trigger(labelName);
    }

    @Override
    public boolean trigger() {
        return this.localStubRunner.trigger();
    }

    @Override
    public Map<String, Collection<String>> labels() {
        return this.localStubRunner.labels();
    }

    private void registerShutdownHook() {
        Runnable stopAllServers = new Runnable(){

            @Override
            public void run() {
                try {
                    StubRunner.this.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(new Thread(stopAllServers));
    }

    @Override
    public void close() throws IOException {
        if (this.localStubRunner != null) {
            this.localStubRunner.shutdown();
        }
    }
}

