/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import java.util.Collection;
import java.util.Map;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;

public class StubRunnerOptions {
    final Integer minPortValue;
    final Integer maxPortValue;
    final String stubRepositoryRoot;
    final boolean workOffline;
    final String stubsClassifier;
    final Collection<StubConfiguration> dependencies;
    final Map<StubConfiguration, Integer> stubIdsToPortMapping;
    final String contextPath;

    public StubRunnerOptions(Integer minPortValue, Integer maxPortValue, String stubRepositoryRoot, boolean workOffline, String stubsClassifier, Collection<StubConfiguration> dependencies, Map<StubConfiguration, Integer> stubIdsToPortMapping) {
        this.minPortValue = minPortValue;
        this.maxPortValue = maxPortValue;
        this.stubRepositoryRoot = stubRepositoryRoot;
        this.workOffline = workOffline;
        this.stubsClassifier = stubsClassifier;
        this.dependencies = dependencies;
        this.stubIdsToPortMapping = stubIdsToPortMapping;
        this.contextPath = "";
    }

    public StubRunnerOptions(Integer minPortValue, Integer maxPortValue, String stubRepositoryRoot, boolean workOffline, String stubsClassifier, Collection<StubConfiguration> dependencies, Map<StubConfiguration, Integer> stubIdsToPortMapping, String contextPath) {
        this.minPortValue = minPortValue;
        this.maxPortValue = maxPortValue;
        this.stubRepositoryRoot = stubRepositoryRoot;
        this.workOffline = workOffline;
        this.stubsClassifier = stubsClassifier;
        this.dependencies = dependencies;
        this.stubIdsToPortMapping = stubIdsToPortMapping;
        this.contextPath = contextPath;
    }

    public Integer port(StubConfiguration stubConfiguration) {
        if (this.stubIdsToPortMapping != null) {
            return this.stubIdsToPortMapping.get(stubConfiguration);
        }
        return null;
    }

    public Integer getMinPortValue() {
        return this.minPortValue;
    }

    public Integer getMaxPortValue() {
        return this.maxPortValue;
    }

    public Collection<StubConfiguration> getDependencies() {
        return this.dependencies;
    }

    public Map<StubConfiguration, Integer> getStubIdsToPortMapping() {
        return this.stubIdsToPortMapping;
    }

    public String toString() {
        return "StubRunnerOptions [minPortValue=" + this.minPortValue + ", maxPortValue=" + this.maxPortValue + ", stubRepositoryRoot=" + this.stubRepositoryRoot + ", workOffline=" + this.workOffline + ", stubsClassifier=" + this.stubsClassifier + ", dependencies=" + this.dependencies + ", stubIdsToPortMapping=" + this.stubIdsToPortMapping + "]";
    }
}

