/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.server;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.contract.stubrunner.StubFinder;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/triggers"}, produces={"application/json"})
public class TriggerController {
    private static final Logger log = LoggerFactory.getLogger(TriggerController.class);
    private final StubFinder stubFinder;

    @Autowired
    public TriggerController(StubFinder stubFinder) {
        this.stubFinder = stubFinder;
    }

    @PostMapping(value={"/{label:.*}"})
    public ResponseEntity<Map<String, Collection<String>>> trigger(@PathVariable String label) {
        try {
            this.stubFinder.trigger(label);
            return ResponseEntity.ok().body(Collections.emptyMap());
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Exception occurred while trying to return " + label + " label", (Throwable)e);
            }
            return new ResponseEntity(this.stubFinder.labels(), HttpStatus.NOT_FOUND);
        }
    }

    @PostMapping(value={"/{ivyNotation:.*}/{label:.*}"})
    public ResponseEntity<Map<String, Collection<String>>> triggerByArtifact(@PathVariable String ivyNotation, @PathVariable String label) {
        try {
            this.stubFinder.trigger(ivyNotation, label);
            return ResponseEntity.ok().body(Collections.emptyMap());
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Exception occurred while trying to return " + label + " label", (Throwable)e);
            }
            return new ResponseEntity(this.stubFinder.labels(), HttpStatus.NOT_FOUND);
        }
    }

    @GetMapping
    public Map<String, Collection<String>> labels() {
        return this.stubFinder.labels();
    }
}

