/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.spring;

import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.contract.stubrunner.AetherStubDownloader;
import org.springframework.cloud.contract.stubrunner.BatchStubRunner;
import org.springframework.cloud.contract.stubrunner.BatchStubRunnerFactory;
import org.springframework.cloud.contract.stubrunner.StubDownloader;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptions;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptionsBuilder;
import org.springframework.cloud.contract.stubrunner.spring.StubRunnerProperties;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifier;
import org.springframework.cloud.contract.verifier.messaging.noop.NoOpStubMessages;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;

@Configuration
@EnableConfigurationProperties(value={StubRunnerProperties.class})
@ConditionalOnMissingBean(type={"org.springframework.cloud.contract.wiremock.WiremockServerConfiguration"})
public class StubRunnerConfiguration {
    @Autowired(required=false)
    private MessageVerifier<?> contractVerifierMessaging;
    @Autowired(required=false)
    private StubDownloader stubDownloader;
    @Autowired
    private StubRunnerProperties props;
    @Autowired(required=false)
    private ServerProperties serverProperties;

    @Bean
    public BatchStubRunner batchStubRunner() throws IOException {
        StubRunnerOptions stubRunnerOptions = new StubRunnerOptionsBuilder().withMinMaxPort(this.props.getMinPort(), this.props.getMaxPort()).withStubRepositoryRoot(this.uriStringOrEmpty(this.props.getRepositoryRoot())).withWorkOffline(this.props.getRepositoryRoot() == null || this.props.isWorkOffline()).withStubsClassifier(this.props.getClassifier()).withStubs(this.props.getIds()).withContextPath(this.contextPath()).build();
        BatchStubRunner batchStubRunner = new BatchStubRunnerFactory(stubRunnerOptions, this.stubDownloader != null ? this.stubDownloader : new AetherStubDownloader(stubRunnerOptions), (MessageVerifier<?>)(this.contractVerifierMessaging != null ? this.contractVerifierMessaging : new NoOpStubMessages())).buildBatchStubRunner();
        batchStubRunner.runStubs();
        return batchStubRunner;
    }

    private String uriStringOrEmpty(Resource stubRepositoryRoot) throws IOException {
        return stubRepositoryRoot != null ? stubRepositoryRoot.getURI().toString() : "";
    }

    private String contextPath() {
        if (this.serverProperties == null) {
            return "";
        }
        return this.serverProperties.getContextPath();
    }
}

