/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.spring;

import java.util.Arrays;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;

@ConfigurationProperties(value="stubrunner")
public class StubRunnerProperties {
    private int minPort = 10000;
    private int maxPort = 15000;
    private boolean workOffline;
    private Resource repositoryRoot;
    private String[] ids = new String[0];
    private String classifier = "stubs";

    public int getMinPort() {
        return this.minPort;
    }

    public void setMinPort(int minPort) {
        this.minPort = minPort;
    }

    public int getMaxPort() {
        return this.maxPort;
    }

    public void setMaxPort(int maxPort) {
        this.maxPort = maxPort;
    }

    public boolean isWorkOffline() {
        return this.workOffline;
    }

    public void setWorkOffline(boolean workOffline) {
        this.workOffline = workOffline;
    }

    public Resource getRepositoryRoot() {
        return this.repositoryRoot;
    }

    public void setRepositoryRoot(String repositoryRoot) {
        this.repositoryRoot = new DefaultResourceLoader().getResource(repositoryRoot);
    }

    public String[] getIds() {
        return this.ids;
    }

    public void setIds(String[] ids) {
        this.ids = ids;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public String toString() {
        return "StubRunnerProperties{minPort=" + this.minPort + ", maxPort=" + this.maxPort + ", workOffline=" + this.workOffline + ", repositoryRoot=" + this.repositoryRoot + ", ids=" + Arrays.toString(this.ids) + ", classifier='" + this.classifier + '\'' + '}';
    }
}

