/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.spring.cloud.eureka;

import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.shared.Applications;
import com.netflix.discovery.shared.resolver.ClosableResolver;
import com.netflix.discovery.shared.resolver.ClusterResolver;
import com.netflix.discovery.shared.resolver.EurekaEndpoint;
import com.netflix.discovery.shared.resolver.aws.ApplicationsResolver;
import com.netflix.discovery.shared.transport.EurekaHttpClient;
import com.netflix.discovery.shared.transport.EurekaHttpClientFactory;
import com.netflix.discovery.shared.transport.EurekaHttpClients;
import com.netflix.discovery.shared.transport.EurekaHttpResponse;
import com.netflix.discovery.shared.transport.EurekaTransportConfig;
import com.netflix.discovery.shared.transport.TransportClientFactory;
import com.netflix.discovery.shared.transport.decorator.MetricsCollectingEurekaHttpClient;
import com.netflix.discovery.shared.transport.jersey.JerseyEurekaHttpClientFactory;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.cloud.contract.stubrunner.spring.cloud.eureka.Application;
import org.springframework.cloud.contract.stubrunner.spring.cloud.eureka.EurekaTransport;
import org.springframework.cloud.contract.stubrunner.spring.cloud.eureka.Registration;
import org.springframework.cloud.netflix.eureka.CloudEurekaClient;
import org.springframework.cloud.netflix.eureka.EurekaClientConfigBean;
import org.springframework.cloud.netflix.eureka.EurekaInstanceConfigBean;
import org.springframework.cloud.netflix.eureka.InstanceInfoFactory;
import org.springframework.http.HttpStatus;

public class Eureka {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final InetUtils inetUtils;
    final CloudEurekaClient eurekaClient;
    final EurekaClientConfigBean clientConfig;
    final EurekaTransport transport;

    public Eureka(InetUtils inetUtils, EurekaClientConfigBean eurekaClientConfigBean, CloudEurekaClient eurekaClient) {
        this.inetUtils = inetUtils;
        this.eurekaClient = eurekaClient;
        this.clientConfig = new EurekaClientConfigBean();
        this.clientConfig.setRegisterWithEureka(false);
        this.clientConfig.setServiceUrl(eurekaClientConfigBean.getServiceUrl());
        this.transport = this.createTransport();
    }

    public Registration register(Application application) {
        long start = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Starting registration of %s", application));
        }
        InstanceInfo instanceInfo = this.getInstanceInfo(application);
        Registration registration = new Registration(instanceInfo, application);
        long duration = System.currentTimeMillis() - start;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Created registration for %s in %s ms", application, duration));
        }
        this.register(registration);
        return registration;
    }

    public InstanceInfo getInstanceInfo(Application application, long lastUpdatedTimestamp, long lastDirtyTimestamp) {
        InstanceInfo instanceInfo = this.getInstanceInfo(application);
        instanceInfo = new InstanceInfo.Builder(instanceInfo).setLastDirtyTimestamp(lastDirtyTimestamp).setLastUpdatedTimestamp(lastUpdatedTimestamp).build();
        return instanceInfo;
    }

    public InstanceInfo getInstanceInfo(Application application) {
        EurekaInstanceConfigBean instanceConfig = new EurekaInstanceConfigBean(this.inetUtils);
        instanceConfig.setInstanceEnabledOnit(true);
        instanceConfig.setAppname(application.getName());
        instanceConfig.setVirtualHostName(application.getName());
        instanceConfig.setInstanceId(application.getInstance_id());
        instanceConfig.setHostname(application.getHostname());
        instanceConfig.setNonSecurePort(application.getPort());
        return new InstanceInfoFactory().create((EurekaInstanceConfig)instanceConfig);
    }

    public EurekaTransport createTransport() {
        EurekaHttpClientFactory httpClientFactory;
        TransportClientFactory transportClientFactory = Eureka.newTransportClientFactory((EurekaClientConfig)this.clientConfig, Collections.emptyList());
        EurekaTransportConfig transportConfig = this.clientConfig.getTransportConfig();
        ClosableResolver bootstrapResolver = EurekaHttpClients.newBootstrapResolver((EurekaClientConfig)this.clientConfig, (EurekaTransportConfig)transportConfig, (TransportClientFactory)transportClientFactory, null, (ApplicationsResolver.ApplicationsSource)new ApplicationsResolver.ApplicationsSource(){

            public Applications getApplications(int stalenessThreshold, TimeUnit timeUnit) {
                long thresholdInMs = TimeUnit.MILLISECONDS.convert(stalenessThreshold, timeUnit);
                long delay = Eureka.this.eurekaClient.getLastSuccessfulRegistryFetchTimePeriod();
                if (delay > thresholdInMs) {
                    log.info((Object)String.format("Local registry is too stale for local lookup. Threshold:%s, actual:%s", thresholdInMs, delay));
                    return null;
                }
                return Eureka.this.eurekaClient.getApplications();
            }
        });
        try {
            httpClientFactory = EurekaHttpClients.registrationClientFactory((ClusterResolver)bootstrapResolver, (TransportClientFactory)transportClientFactory, (EurekaTransportConfig)transportConfig);
        }
        catch (Exception e) {
            log.warn((Object)"Experimental transport initialization failure", (Throwable)e);
            throw new RuntimeException(e);
        }
        return new EurekaTransport(httpClientFactory, httpClientFactory.newClient(), transportClientFactory, bootstrapResolver);
    }

    public static TransportClientFactory newTransportClientFactory(EurekaClientConfig clientConfig, Collection<ClientFilter> additionalFilters) {
        JerseyEurekaHttpClientFactory jerseyFactory = JerseyEurekaHttpClientFactory.create((EurekaClientConfig)clientConfig, additionalFilters, null, null);
        final TransportClientFactory metricsFactory = MetricsCollectingEurekaHttpClient.createFactory((TransportClientFactory)jerseyFactory);
        return new TransportClientFactory((TransportClientFactory)jerseyFactory){
            final /* synthetic */ TransportClientFactory val$jerseyFactory;
            {
                this.val$jerseyFactory = transportClientFactory2;
            }

            public EurekaHttpClient newClient(EurekaEndpoint serviceUrl) {
                return metricsFactory.newClient(serviceUrl);
            }

            public void shutdown() {
                metricsFactory.shutdown();
                this.val$jerseyFactory.shutdown();
            }
        };
    }

    public boolean renew(Registration registration) {
        InstanceInfo instanceInfo = registration.getInstanceInfo();
        try {
            EurekaHttpResponse httpResponse = this.transport.getEurekaHttpClient().sendHeartBeat(instanceInfo.getAppName(), instanceInfo.getId(), instanceInfo, null);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("EurekaLite_%s/%s - Heartbeat status: %s", instanceInfo.getAppName(), instanceInfo.getId(), httpResponse.getStatusCode()));
            }
            if (httpResponse.getStatusCode() == HttpStatus.NOT_FOUND.value()) {
                log.info((Object)String.format("EurekaLite_%s/%s - Re-registering apps/%s", instanceInfo.getAppName(), instanceInfo.getId(), instanceInfo.getAppName()));
                return this.register(registration);
            }
            return httpResponse.getStatusCode() == HttpStatus.OK.value();
        }
        catch (Exception e) {
            log.error((Object)("EurekaLite_" + instanceInfo.getAppName() + "/" + instanceInfo.getId() + " - was unable to send heartbeat!"), (Throwable)e);
            return false;
        }
    }

    protected boolean register(Registration registration) {
        EurekaHttpResponse httpResponse;
        InstanceInfo instanceInfo = registration.getInstanceInfo();
        log.info((Object)String.format("EurekaLite_%s/%s: registering service...", instanceInfo.getAppName(), instanceInfo.getId()));
        try {
            httpResponse = this.transport.getEurekaHttpClient().register(instanceInfo);
        }
        catch (Exception e) {
            log.warn((Object)("EurekaLite_" + instanceInfo.getAppName() + "/" + instanceInfo.getId() + " - registration failed " + e.getMessage()), (Throwable)e);
            throw e;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("EurekaLite_%s/%s - registration status: %s", instanceInfo.getAppName(), instanceInfo.getId(), httpResponse.getStatusCode()));
        }
        return httpResponse.getStatusCode() == HttpStatus.NO_CONTENT.value();
    }

    public void shutdown(Registration registration) {
        InstanceInfo instanceInfo = registration.getInstanceInfo();
        try {
            EurekaHttpResponse httpResponse = this.transport.getEurekaHttpClient().cancel(instanceInfo.getAppName(), instanceInfo.getInstanceId());
            log.info((Object)String.format("EurekaLite_%s/%s - deregister  status: %s", instanceInfo.getAppName(), instanceInfo.getId(), httpResponse.getStatusCode()));
        }
        catch (Exception e) {
            log.error((Object)("EurekaLite_" + instanceInfo.getAppName() + "/" + instanceInfo.getId() + " - de-registration failed " + e.getMessage()), (Throwable)e);
        }
        this.transport.shutdown();
    }
}

