/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.messaging.camel;

import java.util.Collection;
import java.util.Map;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.spring.SpringRouteBuilder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.stubrunner.BatchStubRunner;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;
import org.springframework.cloud.contract.stubrunner.messaging.camel.StubRunnerCamelPredicate;
import org.springframework.cloud.contract.stubrunner.messaging.camel.StubRunnerCamelProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={RoutesBuilder.class})
@ConditionalOnProperty(name={"stubrunner.camel.enabled"}, havingValue="true", matchIfMissing=true)
public class StubRunnerCamelConfiguration {
    @Bean
    public RoutesBuilder myRouter(final BatchStubRunner batchStubRunner) {
        return new SpringRouteBuilder(){

            public void configure() throws Exception {
                Map<StubConfiguration, Collection<Contract>> contracts = batchStubRunner.getContracts();
                for (Collection<Contract> list : contracts.values()) {
                    for (Contract it : list) {
                        if (it.getInput() == null || it.getInput().getMessageFrom() == null || it.getOutputMessage() == null || it.getOutputMessage().getSentTo() == null) continue;
                        ((ExpressionNode)this.from((String)it.getInput().getMessageFrom().getClientValue()).filter((Predicate)new StubRunnerCamelPredicate(it)).process((Processor)new StubRunnerCamelProcessor(it))).to((String)it.getOutputMessage().getSentTo().getClientValue());
                    }
                }
            }
        };
    }
}

