/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.spring.cloud.eureka;

import com.fasterxml.jackson.annotation.JsonIgnore;

class Application {
    private String name;
    private String instance_id;
    private String hostname;
    private int port;

    public Application(String name, String instance_id, String hostname, int port) {
        this.name = name;
        this.instance_id = instance_id;
        this.hostname = hostname;
        this.port = port;
    }

    public Application() {
    }

    @JsonIgnore
    public String getRegistrationKey() {
        return Application.computeRegistrationKey(this.name, this.instance_id);
    }

    static String computeRegistrationKey(String name, String instanceId) {
        return name + ":" + instanceId;
    }

    public String getName() {
        return this.name;
    }

    public String getInstance_id() {
        return this.instance_id;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }
}

