/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.junit;

import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.stubrunner.BatchStubRunner;
import org.springframework.cloud.contract.stubrunner.BatchStubRunnerFactory;
import org.springframework.cloud.contract.stubrunner.RunningStubs;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;
import org.springframework.cloud.contract.stubrunner.StubFinder;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptions;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptionsBuilder;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifier;

public class StubRunnerRule
implements TestRule,
StubFinder {
    private static final String DELIMITER = ":";
    private static final String LATEST_VERSION = "+";
    private final StubRunnerOptionsBuilder stubRunnerOptionsBuilder = new StubRunnerOptionsBuilder(this.defaultStubRunnerOptions());
    private BatchStubRunner stubFinder;
    private MessageVerifier verifier = new ExceptionThrowingMessageVerifier();

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                this.before();
                base.evaluate();
                StubRunnerRule.this.stubFinder.close();
            }

            private void before() {
                StubRunnerRule.this.stubFinder = new BatchStubRunnerFactory(StubRunnerRule.this.stubRunnerOptionsBuilder.build(), StubRunnerRule.this.verifier).buildBatchStubRunner();
                StubRunnerRule.this.stubFinder.runStubs();
            }
        };
    }

    private StubRunnerOptions defaultStubRunnerOptions() {
        StubRunnerOptionsBuilder builder = new StubRunnerOptionsBuilder().withMinPort(Integer.valueOf(System.getProperty("stubrunner.port.range.min", "10000"))).withMaxPort(Integer.valueOf(System.getProperty("stubrunner.port.range.max", "15000"))).withStubRepositoryRoot(System.getProperty("stubrunner.repository.root", "")).withWorkOffline(Boolean.parseBoolean(System.getProperty("stubrunner.work-offline", "false"))).withStubsClassifier(System.getProperty("stubrunner.classifier", "stubs")).withStubs(System.getProperty("stubrunner.ids", "")).withUsername(System.getProperty("stubrunner.username")).withPassword(System.getProperty("stubrunner.password")).withStubPerConsumer(Boolean.parseBoolean(System.getProperty("stubrunner.stubsPerConsumer", "false"))).withConsumerName(System.getProperty("stubrunner.consumer-name"));
        String proxyHost = System.getProperty("stubrunner.proxy.host");
        if (proxyHost != null) {
            builder.withProxy(proxyHost, Integer.parseInt(System.getProperty("stubrunner.proxy.port")));
        }
        return builder.build();
    }

    public StubRunnerRule messageVerifier(MessageVerifier messageVerifier) {
        this.verifier = messageVerifier;
        return this;
    }

    public StubRunnerRule options(StubRunnerOptions stubRunnerOptions) {
        this.stubRunnerOptionsBuilder.withOptions(stubRunnerOptions);
        return this;
    }

    public StubRunnerRule minPort(int minPort) {
        this.stubRunnerOptionsBuilder.withMinPort(minPort);
        return this;
    }

    public StubRunnerRule maxPort(int maxPort) {
        this.stubRunnerOptionsBuilder.withMaxPort(maxPort);
        return this;
    }

    public StubRunnerRule repoRoot(String repoRoot) {
        this.stubRunnerOptionsBuilder.withStubRepositoryRoot(repoRoot);
        return this;
    }

    public StubRunnerRule workOffline(boolean workOffline) {
        this.stubRunnerOptionsBuilder.withWorkOffline(workOffline);
        return this;
    }

    public StubRunnerRule downloadStub(String groupId, String artifactId, String version, String classifier) {
        this.stubRunnerOptionsBuilder.withStubs(groupId + DELIMITER + artifactId + DELIMITER + version + DELIMITER + classifier);
        return this;
    }

    public StubRunnerRule downloadLatestStub(String groupId, String artifactId, String classifier) {
        this.stubRunnerOptionsBuilder.withStubs(groupId + DELIMITER + artifactId + DELIMITER + LATEST_VERSION + DELIMITER + classifier);
        return this;
    }

    public StubRunnerRule downloadStub(String groupId, String artifactId, String version) {
        this.stubRunnerOptionsBuilder.withStubs(groupId + DELIMITER + artifactId + DELIMITER + version);
        return this;
    }

    public StubRunnerRule downloadStub(String groupId, String artifactId) {
        this.stubRunnerOptionsBuilder.withStubs(groupId + DELIMITER + artifactId);
        return this;
    }

    public StubRunnerRule downloadStub(String ivyNotation) {
        this.stubRunnerOptionsBuilder.withStubs(ivyNotation);
        return this;
    }

    public StubRunnerRule downloadStubs(String ... ivyNotations) {
        this.stubRunnerOptionsBuilder.withStubs(Arrays.asList(ivyNotations));
        return this;
    }

    public StubRunnerRule downloadStubs(List<String> ivyNotations) {
        this.stubRunnerOptionsBuilder.withStubs(ivyNotations);
        return this;
    }

    public StubRunnerRule withPort(Integer port) {
        this.stubRunnerOptionsBuilder.withPort(port);
        return this;
    }

    public StubRunnerRule withStubPerConsumer(boolean stubPerConsumer) {
        this.stubRunnerOptionsBuilder.withStubPerConsumer(stubPerConsumer);
        return this;
    }

    public StubRunnerRule withConsumerName(String consumerName) {
        this.stubRunnerOptionsBuilder.withConsumerName(consumerName);
        return this;
    }

    @Override
    public URL findStubUrl(String groupId, String artifactId) {
        return this.stubFinder.findStubUrl(groupId, artifactId);
    }

    @Override
    public URL findStubUrl(String ivyNotation) {
        return this.stubFinder.findStubUrl(ivyNotation);
    }

    @Override
    public RunningStubs findAllRunningStubs() {
        return this.stubFinder.findAllRunningStubs();
    }

    @Override
    public Map<StubConfiguration, Collection<Contract>> getContracts() {
        return this.stubFinder.getContracts();
    }

    @Override
    public boolean trigger(String ivyNotation, String labelName) {
        boolean result = this.stubFinder.trigger(ivyNotation, labelName);
        if (!result) {
            throw new IllegalStateException("Failed to trigger a message with notation [" + ivyNotation + "] and label [" + labelName + "]");
        }
        return result;
    }

    @Override
    public boolean trigger(String labelName) {
        boolean result = this.stubFinder.trigger(labelName);
        if (!result) {
            throw new IllegalStateException("Failed to trigger a message with label [" + labelName + "]");
        }
        return result;
    }

    @Override
    public boolean trigger() {
        boolean result = this.stubFinder.trigger();
        if (!result) {
            throw new IllegalStateException("Failed to trigger a message");
        }
        return result;
    }

    @Override
    public Map<String, Collection<String>> labels() {
        return this.stubFinder.labels();
    }

    static class ExceptionThrowingMessageVerifier
    implements MessageVerifier {
        private static final String EXCEPTION_MESSAGE = "Please provide a custom MessageVerifier to use this feature";

        ExceptionThrowingMessageVerifier() {
        }

        public void send(Object message, String destination) {
            throw new UnsupportedOperationException(EXCEPTION_MESSAGE);
        }

        public Object receive(String destination, long timeout, TimeUnit timeUnit) {
            throw new UnsupportedOperationException(EXCEPTION_MESSAGE);
        }

        public Object receive(String destination) {
            throw new UnsupportedOperationException(EXCEPTION_MESSAGE);
        }

        public void send(Object payload, Map headers, String destination) {
            throw new UnsupportedOperationException(EXCEPTION_MESSAGE);
        }
    }
}

