/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.spring;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.contract.stubrunner.BatchStubRunner;
import org.springframework.cloud.contract.stubrunner.BatchStubRunnerFactory;
import org.springframework.cloud.contract.stubrunner.RunningStubs;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;
import org.springframework.cloud.contract.stubrunner.StubDownloaderBuilderProvider;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptions;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptionsBuilder;
import org.springframework.cloud.contract.stubrunner.spring.StubRunnerProperties;
import org.springframework.cloud.contract.stubrunner.util.StringUtils;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifier;
import org.springframework.cloud.contract.verifier.messaging.noop.NoOpStubMessages;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;

@Configuration
@EnableConfigurationProperties(value={StubRunnerProperties.class})
@ConditionalOnMissingBean(type={"org.springframework.cloud.contract.wiremock.WiremockServerConfiguration"})
public class StubRunnerConfiguration {
    private static final String STUBRUNNER_PREFIX = "stubrunner.runningstubs";
    @Autowired(required=false)
    private MessageVerifier<?> contractVerifierMessaging;
    private StubDownloaderBuilderProvider provider = new StubDownloaderBuilderProvider();
    @Autowired
    private StubRunnerProperties props;
    @Autowired
    private ConfigurableEnvironment environment;

    @Bean
    public BatchStubRunner batchStubRunner() throws IOException {
        StubRunnerOptionsBuilder builder = this.builder();
        if (this.props.getProxyHost() != null) {
            builder.withProxy(this.props.getProxyHost(), this.props.getProxyPort());
        }
        StubRunnerOptions stubRunnerOptions = builder.build();
        BatchStubRunner batchStubRunner = new BatchStubRunnerFactory(stubRunnerOptions, this.provider.getOrDefaultDownloader(stubRunnerOptions), (MessageVerifier<?>)(this.contractVerifierMessaging != null ? this.contractVerifierMessaging : new NoOpStubMessages())).buildBatchStubRunner();
        RunningStubs runningStubs = batchStubRunner.runStubs();
        this.registerPort(runningStubs);
        return batchStubRunner;
    }

    private StubRunnerOptionsBuilder builder() throws IOException {
        return new StubRunnerOptionsBuilder().withMinMaxPort(this.props.getMinPort(), this.props.getMaxPort()).withStubRepositoryRoot(this.uriStringOrEmpty(this.props.getRepositoryRoot())).withWorkOffline(this.props.isWorkOffline()).withStubsClassifier(this.props.getClassifier()).withStubs(this.props.getIds()).withUsername(this.props.getUsername()).withPassword(this.props.getPassword()).withStubPerConsumer(this.props.isStubsPerConsumer()).withConsumerName(this.consumerName());
    }

    private String consumerName() {
        if (StringUtils.hasText(this.props.getConsumerName())) {
            return this.props.getConsumerName();
        }
        return this.environment.getProperty("spring.application.name");
    }

    private String uriStringOrEmpty(Resource stubRepositoryRoot) throws IOException {
        return stubRepositoryRoot != null ? stubRepositoryRoot.getURI().toString() : "";
    }

    private void registerPort(RunningStubs runStubs) {
        MutablePropertySources propertySources = this.environment.getPropertySources();
        if (!propertySources.contains(STUBRUNNER_PREFIX)) {
            propertySources.addFirst((PropertySource)new MapPropertySource(STUBRUNNER_PREFIX, new HashMap()));
        }
        Map source = (Map)((MapPropertySource)propertySources.get(STUBRUNNER_PREFIX)).getSource();
        for (Map.Entry<StubConfiguration, Integer> entry : runStubs.validNamesAndPorts().entrySet()) {
            source.put("stubrunner.runningstubs." + entry.getKey().getArtifactId() + ".port", entry.getValue());
        }
    }
}

