/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;
import org.springframework.cloud.contract.stubrunner.StubDownloader;
import org.springframework.cloud.contract.verifier.config.ContractVerifierConfigProperties;
import org.springframework.util.StringUtils;

public class ContractDownloader {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final StubDownloader stubDownloader;
    private final StubConfiguration contractsJarStubConfiguration;
    private final String contractsPath;
    private final String projectGroupId;
    private final String projectArtifactId;

    public ContractDownloader(StubDownloader stubDownloader, StubConfiguration contractsJarStubConfiguration, String contractsPath, String projectGroupId, String projectArtifactId) {
        this.stubDownloader = stubDownloader;
        this.contractsJarStubConfiguration = contractsJarStubConfiguration;
        this.contractsPath = contractsPath;
        this.projectGroupId = projectGroupId;
        this.projectArtifactId = projectArtifactId;
    }

    public File unpackedDownloadedContracts(ContractVerifierConfigProperties config) {
        File contractsDirectory = this.unpackAndDownloadContracts();
        this.updatePropertiesWithInclusion(contractsDirectory, config);
        return contractsDirectory;
    }

    public ContractVerifierConfigProperties updatePropertiesWithInclusion(File contractsDirectory, ContractVerifierConfigProperties config) {
        String includedAntPattern;
        String pattern;
        if (StringUtils.hasText((String)this.contractsPath)) {
            pattern = this.patternFromProperty(contractsDirectory);
            log.info((Object)"Will pick a pattern from the contractPath property");
            includedAntPattern = this.wrapWithAntPattern(this.contractsPath());
        } else {
            pattern = this.groupArtifactToPattern(contractsDirectory);
            log.info((Object)"Will pick a pattern from group id and artifact id");
            includedAntPattern = this.wrapWithAntPattern(this.slashSeparatedGroupId() + "/" + this.projectArtifactId);
        }
        log.info((Object)("Pattern to pick contracts equals [" + pattern + "]"));
        log.info((Object)("Ant Pattern to pick files equals [" + includedAntPattern + "]"));
        config.setIncludedContracts(pattern);
        config.setIncludedRootFolderAntPattern(includedAntPattern);
        return config;
    }

    private String patternFromProperty(File contractsDirectory) {
        return ("^" + contractsDirectory.getAbsolutePath() + "(" + File.separator + ")?.*" + this.contractsPath().replace("/", File.separator) + ".*$").replace("\\", "\\\\");
    }

    private String contractsPath() {
        return this.surroundWithSeparator(this.contractsPath);
    }

    private String surroundWithSeparator(String string) {
        String path = string.startsWith(File.separator) ? string : File.separator + string;
        return path.endsWith(File.separator) ? path : path + File.separator;
    }

    private String wrapWithAntPattern(String path) {
        String changedPath = path.replace(File.separator, "/");
        return "**" + this.surroundWithSeparator(changedPath).replace(File.separator, "/") + "**/";
    }

    private File unpackAndDownloadContracts() {
        Map.Entry<StubConfiguration, File> unpackedContractStubs;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will download contracts for [" + this.contractsJarStubConfiguration + "]"));
        }
        if ((unpackedContractStubs = this.stubDownloader.downloadAndUnpackStubJar(this.contractsJarStubConfiguration)) == null) {
            throw new IllegalStateException("The contracts failed to be downloaded!");
        }
        return unpackedContractStubs.getValue();
    }

    private String groupArtifactToPattern(File contractsDirectory) {
        return ("^" + contractsDirectory.getAbsolutePath() + "(" + File.separator + ")?.*" + this.slashSeparatedGroupId() + File.separator + this.projectArtifactId + File.separator + ".*$").replace("\\", "\\\\");
    }

    private String slashSeparatedGroupId() {
        return this.projectGroupId.replace(".", File.separator);
    }
}

