/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.spec.ContractConverter;
import org.springframework.cloud.contract.stubrunner.HttpServerStub;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptions;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptionsBuilder;
import org.springframework.cloud.contract.stubrunner.provider.wiremock.WireMockHttpServerStub;
import org.springframework.cloud.contract.verifier.converter.YamlContractConverter;
import org.springframework.cloud.contract.verifier.util.ContractVerifierDslConverter;
import org.springframework.core.io.support.SpringFactoriesLoader;

class StubRepository {
    private static final Logger log = LoggerFactory.getLogger(StubRepository.class);
    private final File path;
    final List<File> stubs;
    final Collection<Contract> contracts;
    private final List<ContractConverter> contractConverters;
    private final List<HttpServerStub> httpServerStubs;
    private final StubRunnerOptions options;

    StubRepository(File repository, List<HttpServerStub> httpServerStubs, StubRunnerOptions options) {
        if (!repository.isDirectory()) {
            throw new IllegalArgumentException("Missing descriptor repository under path [" + repository + "]");
        }
        this.contractConverters = SpringFactoriesLoader.loadFactories(ContractConverter.class, null);
        if (log.isTraceEnabled()) {
            log.trace("Found the following contract converters " + this.contractConverters);
        }
        this.httpServerStubs = httpServerStubs;
        this.path = repository;
        this.options = options;
        this.stubs = this.stubs();
        this.contracts = this.contracts();
        if (log.isTraceEnabled()) {
            log.trace("Found the following contracts " + this.contracts);
        }
    }

    StubRepository(File repository) {
        this(repository, new ArrayList<HttpServerStub>(), new StubRunnerOptionsBuilder().build());
    }

    public File getPath() {
        return this.path;
    }

    public List<File> getStubs() {
        return this.stubs;
    }

    public Collection<Contract> getContracts() {
        return this.contracts;
    }

    private Collection<Contract> contracts() {
        return new ArrayList<Contract>(this.contractDescriptors());
    }

    private List<File> stubs() {
        return new ArrayList<File>(this.collectedStubs());
    }

    private List<File> collectedStubs() {
        return this.path.exists() ? this.collectMappings(this.path) : Collections.emptyList();
    }

    private List<File> collectMappings(File descriptorsDirectory) {
        final ArrayList<File> mappingDescriptors = new ArrayList<File>();
        try {
            Files.walkFileTree(Paths.get(descriptorsDirectory.toURI()), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                    File file = path.toFile();
                    if (StubRepository.this.httpServerStubAccepts(file) && StubRepository.this.isStubPerConsumerPathMatching(file)) {
                        mappingDescriptors.add(file);
                    }
                    return super.visitFile(path, attrs);
                }
            });
        }
        catch (IOException e) {
            log.warn("Exception occurred while trying to parse file", (Throwable)e);
        }
        return mappingDescriptors;
    }

    private ContractConverter contractConverter(File file) {
        for (ContractConverter converter : this.contractConverters) {
            if (!converter.isAccepted(file)) continue;
            return converter;
        }
        return null;
    }

    private boolean httpServerStubAccepts(File file) {
        for (HttpServerStub httpServerStub : this.httpServerStubs) {
            if (!httpServerStub.isAccepted(file)) continue;
            return true;
        }
        return new WireMockHttpServerStub().isAccepted(file);
    }

    private Collection<Contract> contractDescriptors() {
        return this.path.exists() ? this.collectContractDescriptors(this.path) : Collections.emptySet();
    }

    private Collection<Contract> collectContractDescriptors(File descriptorsDirectory) {
        final ArrayList<Contract> contractDescriptors = new ArrayList<Contract>();
        try {
            Files.walkFileTree(Paths.get(descriptorsDirectory.toURI()), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                    File file = path.toFile();
                    ContractConverter converter = StubRepository.this.contractConverter(file);
                    if (StubRepository.this.isStubPerConsumerPathMatching(file)) {
                        if (StubRepository.isContractDescriptor(file)) {
                            contractDescriptors.addAll(ContractVerifierDslConverter.convertAsCollection((File)file.getParentFile(), (File)file));
                        } else if (YamlContractConverter.INSTANCE.isAccepted(file)) {
                            contractDescriptors.addAll(YamlContractConverter.INSTANCE.convertFrom(file));
                        } else if (converter != null) {
                            contractDescriptors.addAll(converter.convertFrom(file));
                        }
                    }
                    return super.visitFile(path, attrs);
                }
            });
        }
        catch (IOException e) {
            log.warn("Exception occurred while trying to parse file", (Throwable)e);
        }
        return contractDescriptors;
    }

    private boolean isStubPerConsumerPathMatching(File file) {
        if (!this.options.isStubsPerConsumer()) {
            return true;
        }
        String consumerName = this.options.getConsumerName();
        return file.getAbsolutePath().contains(File.separator + consumerName + File.separator);
    }

    private static boolean isContractDescriptor(File file) {
        return file.isFile() && file.getName().endsWith(".groovy");
    }
}

