/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import org.springframework.util.StringUtils;

public class StubConfiguration {
    private static final String STUB_COLON_DELIMITER = ":";
    static final String DEFAULT_VERSION = "+";
    public static final String DEFAULT_CLASSIFIER = "stubs";
    final String groupId;
    final String artifactId;
    final String version;
    final String classifier;

    public StubConfiguration(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.classifier = DEFAULT_CLASSIFIER;
    }

    public StubConfiguration(String groupId, String artifactId, String version, String classifier) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.classifier = classifier;
    }

    public StubConfiguration(String stubPath, String defaultClassifier) {
        String[] parsedPath = this.parsedPathEmptyByDefault(stubPath, STUB_COLON_DELIMITER, defaultClassifier);
        this.groupId = parsedPath[0];
        this.artifactId = parsedPath[1];
        this.version = parsedPath[2];
        this.classifier = parsedPath[3];
    }

    public StubConfiguration(String stubPath) {
        String[] parsedPath = this.parsedPathEmptyByDefault(stubPath, STUB_COLON_DELIMITER, DEFAULT_CLASSIFIER);
        this.groupId = parsedPath[0];
        this.artifactId = parsedPath[1];
        this.version = parsedPath[2];
        this.classifier = parsedPath[3];
    }

    private String[] parsedPathEmptyByDefault(String path, String delimiter, String defaultClassifier) {
        String[] splitPath = path.split(delimiter, -1);
        String stubsGroupId = "";
        String stubsArtifactId = "";
        String stubsVersion = "";
        String stubsClassifier = "";
        if (splitPath.length >= 2) {
            stubsGroupId = splitPath[0];
            stubsArtifactId = splitPath[1];
            stubsVersion = splitPath.length >= 3 ? splitPath[2] : DEFAULT_VERSION;
            stubsClassifier = splitPath.length >= 4 ? splitPath[3] : defaultClassifier;
        }
        return new String[]{stubsGroupId, stubsArtifactId, stubsVersion, stubsClassifier};
    }

    private boolean isDefined() {
        return StringUtils.hasText((String)this.groupId) && StringUtils.hasText((String)this.artifactId);
    }

    public String toColonSeparatedDependencyNotation() {
        if (!this.isDefined()) {
            return "";
        }
        return StringUtils.arrayToDelimitedString((Object[])new String[]{this.nullCheck(this.groupId), this.nullCheck(this.artifactId), this.nullCheck(this.version), this.nullCheck(this.classifier)}, (String)STUB_COLON_DELIMITER);
    }

    private String nullCheck(String value) {
        return StringUtils.hasText((String)value) ? value : "";
    }

    public boolean groupIdAndArtifactMatches(String ivyNotationAsString) {
        String[] parts = this.ivyNotationFrom(ivyNotationAsString);
        String groupId = parts[0];
        String artifactId = parts[1];
        if (groupId == null) {
            return this.artifactId.equals(artifactId);
        }
        return this.groupId.equals(groupId) && this.artifactId.equals(artifactId);
    }

    public boolean isVersionChanging() {
        return DEFAULT_VERSION.equals(this.version) || this.version.toLowerCase().contains("snapshot");
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getVersion() {
        return this.version;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
        result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StubConfiguration other = (StubConfiguration)obj;
        if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
            return false;
        }
        return !(this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId));
    }

    public boolean matchesIvyNotation(String ivyNotationAsString) {
        String[] strings = ivyNotationAsString.split(STUB_COLON_DELIMITER, -1);
        if (strings.length == 1) {
            return this.artifactId.equals(ivyNotationAsString);
        }
        if (!(strings.length < 2 || this.groupId.equals(strings[0]) && this.artifactId.equals(strings[1]))) {
            return false;
        }
        if (strings.length >= 3 && !this.version.equals(strings[2]) && !DEFAULT_VERSION.equals(strings[2])) {
            return false;
        }
        return strings.length != 4 || this.classifier.equals(strings[3]) || DEFAULT_CLASSIFIER.equals(strings[3]);
    }

    private String[] ivyNotationFrom(String ivyNotation) {
        String[] splitString = ivyNotation.split(STUB_COLON_DELIMITER);
        if (splitString.length == 1) {
            return new String[]{null, splitString[0]};
        }
        return new String[]{splitString[0], splitString[1]};
    }

    public String toString() {
        return this.toColonSeparatedDependencyNotation();
    }
}

