/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.provider.wiremock;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.common.Slf4jNotifier;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.contract.stubrunner.HttpServerStub;
import org.springframework.cloud.contract.verifier.builder.handlebars.HandlebarsEscapeHelper;
import org.springframework.cloud.contract.verifier.builder.handlebars.HandlebarsJsonPathHelper;
import org.springframework.cloud.contract.verifier.dsl.wiremock.DefaultResponseTransformer;
import org.springframework.cloud.contract.verifier.dsl.wiremock.WireMockExtensions;
import org.springframework.cloud.contract.wiremock.WireMockSpring;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.util.ClassUtils;
import org.springframework.util.SocketUtils;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;
import wiremock.com.github.jknack.handlebars.Helper;

public class WireMockHttpServerStub
implements HttpServerStub {
    private static final Logger log = LoggerFactory.getLogger(WireMockHttpServerStub.class);
    private static final int INVALID_PORT = -1;
    private WireMockServer wireMockServer;

    private WireMockConfiguration config() {
        if (ClassUtils.isPresent((String)"org.springframework.cloud.contract.wiremock.WireMockSpring", null)) {
            return WireMockSpring.options().extensions(this.responseTransformers());
        }
        return new WireMockConfiguration().extensions(this.responseTransformers());
    }

    private Extension[] responseTransformers() {
        List wireMockExtensions = SpringFactoriesLoader.loadFactories(WireMockExtensions.class, null);
        ArrayList<DefaultResponseTransformer> extensions = new ArrayList<DefaultResponseTransformer>();
        if (!wireMockExtensions.isEmpty()) {
            for (WireMockExtensions wireMockExtension : wireMockExtensions) {
                extensions.addAll(wireMockExtension.extensions());
            }
        } else {
            extensions.add(new DefaultResponseTransformer(false, this.helpers()));
        }
        return extensions.toArray(new Extension[extensions.size()]);
    }

    @Deprecated
    protected Map<String, Helper> helpers() {
        HashMap<String, Helper> helpers = new HashMap<String, Helper>();
        helpers.put("jsonpath", (Helper)new HandlebarsJsonPathHelper());
        helpers.put("escapejsonbody", (Helper)new HandlebarsEscapeHelper());
        return helpers;
    }

    @Override
    public int port() {
        return this.isRunning() ? this.wireMockServer.port() : -1;
    }

    @Override
    public boolean isRunning() {
        return this.wireMockServer != null && this.wireMockServer.isRunning();
    }

    @Override
    public HttpServerStub start() {
        if (this.isRunning()) {
            if (log.isTraceEnabled()) {
                log.trace("The server is already running at port [" + this.port() + "]");
            }
            return this;
        }
        return this.start(SocketUtils.findAvailableTcpPort());
    }

    @Override
    public HttpServerStub start(int port) {
        this.wireMockServer = new WireMockServer((Options)this.config().port(port).notifier((Notifier)new Slf4jNotifier(true)));
        this.wireMockServer.start();
        return this;
    }

    @Override
    public HttpServerStub stop() {
        if (!this.isRunning()) {
            if (log.isTraceEnabled()) {
                log.trace("Trying to stop a non started server!");
            }
            return this;
        }
        this.wireMockServer.stop();
        return this;
    }

    @Override
    public HttpServerStub registerMappings(Collection<File> stubFiles) {
        if (!this.isRunning()) {
            throw new IllegalStateException("Server not started!");
        }
        this.registerStubMappings(stubFiles);
        return this;
    }

    @Override
    public String registeredMappings() {
        ArrayList<String> mappings = new ArrayList<String>();
        for (StubMapping stubMapping : this.wireMockServer.getStubMappings()) {
            mappings.add(stubMapping.toString());
        }
        return this.jsonArrayOfMappings(mappings);
    }

    private String jsonArrayOfMappings(Collection<String> mappings) {
        return "[" + StringUtils.collectionToDelimitedString(mappings, (String)",\n") + "]";
    }

    @Override
    public boolean isAccepted(File file) {
        return file.getName().endsWith(".json");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    StubMapping getMapping(File file) {
        try (InputStream stream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            StubMapping stubMapping = StubMapping.buildFrom((String)StreamUtils.copyToString((InputStream)stream, (Charset)Charset.forName("UTF-8")));
            return stubMapping;
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot read file", e);
        }
    }

    private void registerStubMappings(Collection<File> stubFiles) {
        WireMock wireMock = new WireMock("localhost", this.port(), "");
        this.registerDefaultHealthChecks(wireMock);
        this.registerStubs(stubFiles, wireMock);
    }

    private void registerDefaultHealthChecks(WireMock wireMock) {
        this.registerHealthCheck(wireMock, "/ping");
        this.registerHealthCheck(wireMock, "/health");
    }

    private void registerStubs(Collection<File> sortedMappings, WireMock wireMock) {
        for (File mappingDescriptor : sortedMappings) {
            try {
                wireMock.register(this.getMapping(mappingDescriptor));
                if (!log.isDebugEnabled()) continue;
                log.debug("Registered stub mappings from [" + mappingDescriptor + "]");
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Failed to register the stub mapping [" + mappingDescriptor + "]", (Throwable)e);
            }
        }
    }

    private void registerHealthCheck(WireMock wireMock, String url) {
        this.registerHealthCheck(wireMock, url, "OK");
    }

    private void registerHealthCheck(WireMock wireMock, String url, String body) {
        wireMock.register(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)url)).willReturn(WireMock.aResponse().withBody(body).withStatus(200)));
    }
}

