/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;

public class RunningStubs {
    private final Map<StubConfiguration, Integer> namesAndPorts = new LinkedHashMap<StubConfiguration, Integer>();

    public RunningStubs(Map<StubConfiguration, Integer> map) {
        this.namesAndPorts.putAll(map);
    }

    public RunningStubs(Collection<RunningStubs> runningStubs) {
        for (RunningStubs it : runningStubs) {
            this.namesAndPorts.putAll(it.namesAndPorts);
        }
    }

    public Integer getPort(String artifactId) {
        return this.getEntry(artifactId) == null ? null : this.getEntry(artifactId).getValue();
    }

    public Map.Entry<StubConfiguration, Integer> getEntry(String artifactId) {
        for (Map.Entry<StubConfiguration, Integer> it : this.namesAndPorts.entrySet()) {
            if (!it.getKey().matchesIvyNotation(artifactId)) continue;
            return it;
        }
        return null;
    }

    public Integer getPort(String groupId, String artifactId) {
        for (Map.Entry<StubConfiguration, Integer> it : this.namesAndPorts.entrySet()) {
            if (!it.getKey().matchesIvyNotation(groupId + ":" + artifactId)) continue;
            return it.getValue();
        }
        return null;
    }

    public boolean isPresent(String artifactId) {
        return this.getEntry(artifactId) != null;
    }

    public boolean isPresent(String groupId, String artifactId) {
        return this.getPort(groupId, artifactId) != null;
    }

    public Set<StubConfiguration> getAllServices() {
        return this.namesAndPorts.keySet();
    }

    public Set<String> getAllServicesNames() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Map.Entry<StubConfiguration, Integer> it : this.namesAndPorts.entrySet()) {
            result.add(it.getKey().artifactId);
        }
        return result;
    }

    public Map<String, Integer> toIvyToPortMapping() {
        LinkedHashMap<String, Integer> result = new LinkedHashMap<String, Integer>();
        for (Map.Entry<StubConfiguration, Integer> it : this.namesAndPorts.entrySet()) {
            result.put(it.getKey().toColonSeparatedDependencyNotation(), it.getValue());
        }
        return result;
    }

    public Map<StubConfiguration, Integer> validNamesAndPorts() {
        LinkedHashMap<StubConfiguration, Integer> result = new LinkedHashMap<StubConfiguration, Integer>();
        for (Map.Entry<StubConfiguration, Integer> it : this.namesAndPorts.entrySet()) {
            if (it.getValue() == null || it.getValue() < 0) continue;
            result.put(it.getKey(), it.getValue());
        }
        return result;
    }

    public String toString() {
        return "RunningStubs [namesAndPorts=" + this.namesAndPorts + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.namesAndPorts == null ? 0 : this.namesAndPorts.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RunningStubs other = (RunningStubs)obj;
        return !(this.namesAndPorts == null ? other.namesAndPorts != null : !this.namesAndPorts.equals(other.namesAndPorts));
    }
}

