/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.messaging.integration;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.spec.internal.FromFileProperty;
import org.springframework.cloud.contract.stubrunner.messaging.integration.StubRunnerIntegrationMessageSelector;
import org.springframework.cloud.contract.verifier.util.BodyExtractor;
import org.springframework.integration.transformer.GenericTransformer;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.MessageBuilder;

class StubRunnerIntegrationTransformer
implements GenericTransformer<Message<?>, Message<?>> {
    private final StubRunnerIntegrationMessageSelector selector;

    StubRunnerIntegrationTransformer(Contract groovyDsl) {
        this(Collections.singletonList(groovyDsl));
    }

    StubRunnerIntegrationTransformer(List<Contract> groovyDsls) {
        this.selector = new StubRunnerIntegrationMessageSelector(groovyDsls);
    }

    public Message<?> transform(Message<?> source) {
        Contract groovyDsl = this.matchingContract(source);
        if (groovyDsl == null || groovyDsl.getOutputMessage() == null) {
            return source;
        }
        Object outputBody = this.outputBody(groovyDsl);
        Map headers = groovyDsl.getOutputMessage().getHeaders().asStubSideMap();
        MessageHeaders messageHeaders = new MessageHeaders(headers);
        Message message = MessageBuilder.createMessage((Object)outputBody, (MessageHeaders)messageHeaders);
        this.selector.updateCache(message, groovyDsl);
        return message;
    }

    private Object outputBody(Contract groovyDsl) {
        Object outputBody = BodyExtractor.extractClientValueFromBody((Object)groovyDsl.getOutputMessage().getBody());
        if (outputBody instanceof FromFileProperty) {
            FromFileProperty property = (FromFileProperty)outputBody;
            return property.asBytes();
        }
        return BodyExtractor.extractStubValueFrom((Object)outputBody);
    }

    Contract matchingContract(Message<?> source) {
        return this.selector.matchingContract(source);
    }
}

