/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.cloud.contract.stubrunner.AetherStubDownloaderBuilder;
import org.springframework.cloud.contract.stubrunner.ClasspathStubProvider;
import org.springframework.cloud.contract.stubrunner.CompositeStubDownloader;
import org.springframework.cloud.contract.stubrunner.ScmStubDownloaderBuilder;
import org.springframework.cloud.contract.stubrunner.StubDownloader;
import org.springframework.cloud.contract.stubrunner.StubDownloaderBuilder;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptions;
import org.springframework.core.io.support.SpringFactoriesLoader;

public class StubDownloaderBuilderProvider {
    private final List<StubDownloaderBuilder> builders = new ArrayList<StubDownloaderBuilder>();

    public StubDownloaderBuilderProvider() {
        this.builders.addAll(SpringFactoriesLoader.loadFactories(StubDownloaderBuilder.class, null));
    }

    StubDownloaderBuilderProvider(List<StubDownloaderBuilder> builders) {
        this.builders.addAll(builders);
    }

    public StubDownloader get(StubRunnerOptions stubRunnerOptions, StubDownloaderBuilder ... additionalBuilders) {
        List<StubDownloaderBuilder> builders = this.builders;
        if (additionalBuilders != null) {
            builders.addAll(Arrays.asList(additionalBuilders));
        }
        List<StubDownloaderBuilder> defaultBuilders = this.defaultStubDownloaderBuilders();
        builders.addAll(defaultBuilders);
        return new CompositeStubDownloader(builders, stubRunnerOptions);
    }

    List<StubDownloaderBuilder> defaultStubDownloaderBuilders() {
        return Arrays.asList(new ScmStubDownloaderBuilder(), new ClasspathStubProvider(), new AetherStubDownloaderBuilder());
    }
}

