/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.server;

import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.contract.stubrunner.StubRunning;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/stubs"}, produces={"application/json"})
public class HttpStubsController {
    private final StubRunning stubRunning;

    @Autowired
    public HttpStubsController(StubRunning stubRunning) {
        this.stubRunning = stubRunning;
    }

    @RequestMapping
    public Map<String, Integer> stubs() {
        return this.stubRunning.runStubs().toIvyToPortMapping();
    }

    @RequestMapping(path={"/{ivy:.*}"})
    public ResponseEntity<Integer> consumer(@PathVariable String ivy) {
        Integer port = this.stubRunning.runStubs().getPort(ivy);
        if (port != null) {
            return ResponseEntity.ok((Object)port);
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }
}

