/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.messaging.integration;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.stubrunner.BatchStubRunner;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;
import org.springframework.cloud.contract.stubrunner.messaging.integration.StubRunnerIntegrationMessageSelector;
import org.springframework.cloud.contract.stubrunner.messaging.integration.StubRunnerIntegrationRouter;
import org.springframework.cloud.contract.stubrunner.messaging.integration.StubRunnerIntegrationTransformer;
import org.springframework.context.Lifecycle;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.core.GenericSelector;
import org.springframework.integration.dsl.FilterEndpointSpec;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.dsl.IntegrationFlows;
import org.springframework.integration.router.AbstractMessageRouter;
import org.springframework.messaging.Message;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={IntegrationFlowBuilder.class})
@ConditionalOnProperty(name={"stubrunner.integration.enabled"}, havingValue="true", matchIfMissing=true)
public class StubRunnerIntegrationConfiguration {
    @Bean
    @ConditionalOnMissingBean(name={"stubFlowRegistrar"})
    public FlowRegistrar stubFlowRegistrar(AutowireCapableBeanFactory beanFactory, BatchStubRunner batchStubRunner) {
        Map<StubConfiguration, Collection<Contract>> contracts = batchStubRunner.getContracts();
        IntegrationFlowBuilder dummyBuilder = (IntegrationFlowBuilder)IntegrationFlows.from((String)DummyMessageHandler.CHANNEL_NAME).handle((Object)new DummyMessageHandler(), "handle");
        beanFactory.initializeBean((Object)dummyBuilder.get(), DummyMessageHandler.CHANNEL_NAME + ".flow");
        for (Map.Entry<StubConfiguration, Collection<Contract>> entry : contracts.entrySet()) {
            StubConfiguration key = entry.getKey();
            Collection<Contract> value = entry.getValue();
            String name = key.getGroupId() + "_" + key.getArtifactId();
            LinkedMultiValueMap map = new LinkedMultiValueMap();
            for (Contract dsl : value) {
                if (dsl == null || dsl.getInput() == null || dsl.getInput().getMessageFrom() == null || !StringUtils.hasText((String)((String)dsl.getInput().getMessageFrom().getClientValue()))) continue;
                String from = (String)dsl.getInput().getMessageFrom().getClientValue();
                map.add((Object)from, (Object)dsl);
            }
            for (Map.Entry entries : map.entrySet()) {
                final String flowName = name + "_" + (String)entries.getKey() + "_" + ((List)entries.getValue()).hashCode();
                IntegrationFlowBuilder builder = (IntegrationFlowBuilder)((IntegrationFlowBuilder)((IntegrationFlowBuilder)IntegrationFlows.from((String)((String)entries.getKey())).filter((GenericSelector)new StubRunnerIntegrationMessageSelector((List)entries.getValue()), (Consumer)new Consumer<FilterEndpointSpec>(){

                    @Override
                    public void accept(FilterEndpointSpec e) {
                        e.id(flowName + ".filter");
                    }
                })).transform((Object)new StubRunnerIntegrationTransformer((List)entries.getValue()))).route((AbstractMessageRouter)new StubRunnerIntegrationRouter((List)entries.getValue(), (BeanFactory)beanFactory));
                beanFactory.initializeBean((Object)builder.get(), flowName);
                ((Lifecycle)beanFactory.getBean(flowName + ".filter", Lifecycle.class)).start();
            }
        }
        return new FlowRegistrar();
    }

    static class DummyMessageHandler {
        static String CHANNEL_NAME = "stub_runner_dummy_channel";

        DummyMessageHandler() {
        }

        public void handle(Message<?> message) {
        }
    }

    static class FlowRegistrar {
        FlowRegistrar() {
        }
    }
}

