/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.io.File;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.JUnitMessagingMethodBodyBuilder;
import org.springframework.cloud.contract.verifier.builder.JaxRsClientJUnitMethodBodyBuilder;
import org.springframework.cloud.contract.verifier.builder.JaxRsClientSpockMethodRequestProcessingBodyBuilder;
import org.springframework.cloud.contract.verifier.builder.MethodBodyBuilder;
import org.springframework.cloud.contract.verifier.builder.MockMvcJUnitMethodBodyBuilder;
import org.springframework.cloud.contract.verifier.builder.MockMvcSpockMethodRequestProcessingBodyBuilder;
import org.springframework.cloud.contract.verifier.builder.SpockMessagingMethodBodyBuilder;
import org.springframework.cloud.contract.verifier.config.ContractVerifierConfigProperties;
import org.springframework.cloud.contract.verifier.config.TestFramework;
import org.springframework.cloud.contract.verifier.config.TestMode;
import org.springframework.cloud.contract.verifier.file.ContractMetadata;
import org.springframework.cloud.contract.verifier.util.NamesUtil;

class MethodBuilder
implements GroovyObject {
    private final String methodName;
    private final Contract stubContent;
    private final ContractVerifierConfigProperties configProperties;
    private final boolean ignored;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    /*
     * WARNING - void declaration
     */
    private MethodBuilder(String string, Contract contract, ContractVerifierConfigProperties contractVerifierConfigProperties, boolean bl) {
        void configProperties;
        void methodName;
        void stubContent;
        void ignored;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        void var6_6 = ignored;
        this.ignored = var6_6;
        void var7_7 = stubContent;
        this.stubContent = var7_7;
        void var8_8 = methodName;
        this.methodName = var8_8;
        void var9_9 = configProperties;
        this.configProperties = var9_9;
    }

    public static MethodBuilder createTestMethod(ContractMetadata contract, File stubsFile, Contract stubContent, ContractVerifierConfigProperties configProperties) {
        if (log.isDebugEnabled()) {
            Object v0;
            if (DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.invokeMethod0(MethodBuilder.class, (Object)log, (String)"isDebugEnabled"))) {
                log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{stubContent}, new String[]{"Stub content Groovy DSL [", "]"})));
                v0 = null;
            } else {
                v0 = null;
            }
        }
        String methodName = NamesUtil.camelCase(NamesUtil.toLastDot(NamesUtil.afterLast(stubsFile.getPath(), File.separator)));
        return new MethodBuilder(methodName, stubContent, configProperties, contract.isIgnored() || stubContent.getIgnored());
    }

    public void appendTo(BlockBuilder blockBuilder) {
        if (ScriptBytecodeAdapter.compareEqual((Object)((Object)this.configProperties.getTargetFramework()), (Object)((Object)TestFramework.JUNIT))) {
            blockBuilder.addLine("@Test");
        }
        if (this.ignored) {
            blockBuilder.addLine("@Ignore");
        }
        blockBuilder.addLine(StringGroovyMethods.plus((String)this.configProperties.getTargetFramework().getMethodModifier(), (CharSequence)new GStringImpl(new Object[]{this.methodName}, new String[]{"validate_", "() throws Exception {"})));
        this.getMethodBodyBuilder().appendTo(blockBuilder);
        blockBuilder.addLine("}");
    }

    private MethodBodyBuilder getMethodBodyBuilder() {
        if (DefaultTypeTransformation.booleanUnbox((Object)this.stubContent.getInput()) || DefaultTypeTransformation.booleanUnbox((Object)this.stubContent.getOutputMessage())) {
            if (ScriptBytecodeAdapter.compareEqual((Object)((Object)this.configProperties.getTargetFramework()), (Object)((Object)TestFramework.JUNIT))) {
                return new JUnitMessagingMethodBodyBuilder(this.stubContent, this.configProperties);
            }
            return new SpockMessagingMethodBodyBuilder(this.stubContent, this.configProperties);
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)((Object)this.configProperties.getTestMode()), (Object)((Object)TestMode.MOCKMVC)) && ScriptBytecodeAdapter.compareEqual((Object)((Object)this.configProperties.getTargetFramework()), (Object)((Object)TestFramework.JUNIT))) {
            return new MockMvcJUnitMethodBodyBuilder(this.stubContent, this.configProperties);
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)((Object)this.configProperties.getTestMode()), (Object)((Object)TestMode.JAXRSCLIENT))) {
            if (ScriptBytecodeAdapter.compareEqual((Object)((Object)this.configProperties.getTargetFramework()), (Object)((Object)TestFramework.JUNIT))) {
                return new JaxRsClientJUnitMethodBodyBuilder(this.stubContent, this.configProperties);
            }
            return new JaxRsClientSpockMethodRequestProcessingBodyBuilder(this.stubContent, this.configProperties);
        }
        return new MockMvcSpockMethodRequestProcessingBodyBuilder(this.stubContent, this.configProperties);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != MethodBuilder.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"org.springframework.cloud.contract.verifier.builder.MethodBuilder");
    }
}

