/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.file;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.io.File;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.SystemUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.contract.verifier.file.ContractMetadata;

public class ContractFileScanner
implements GroovyObject {
    private static final String MATCH_PREFIX = "glob:";
    private static final Pattern SCENARIO_STEP_FILENAME_PATTERN;
    private final File baseDir;
    private final Set<PathMatcher> excludeMatchers;
    private final Set<PathMatcher> ignoreMatchers;
    private final String includeMatcher;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    /*
     * WARNING - void declaration
     */
    public ContractFileScanner(File file, Set<String> set, Set<String> set2, String string) {
        void includeMatcher;
        void ignored;
        void excluded;
        void baseDir;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        void var6_6 = baseDir;
        this.baseDir = var6_6;
        void var7_7 = excluded;
        Set<PathMatcher> set3 = this.processPatterns((Set<String>)(DefaultTypeTransformation.booleanUnbox((Object)var7_7) ? var7_7 : (Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class)));
        this.excludeMatchers = set3;
        void var9_9 = ignored;
        Set<PathMatcher> set4 = this.processPatterns((Set<String>)(DefaultTypeTransformation.booleanUnbox((Object)var9_9) ? var9_9 : (Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class)));
        this.ignoreMatchers = set4;
        void var11_11 = includeMatcher;
        this.includeMatcher = var11_11;
    }

    public ContractFileScanner(File baseDir, Set<String> excluded, Set<String> ignored) {
        this(baseDir, excluded, ignored, "");
    }

    private Set<PathMatcher> processPatterns(Set<String> patterns) {
        Reference fileSystem = new Reference((Object)FileSystems.getDefault());
        public class _processPatterns_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference fileSystem;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _processPatterns_closure1(Object _outerInstance, Object _thisObject, Reference fileSystem) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.fileSystem = reference = fileSystem;
            }

            public Object doCall(Object it) {
                String syntaxAndPattern = StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)MATCH_PREFIX, (CharSequence)"**"), (CharSequence)File.separator), (CharSequence)((CharSequence)ScriptBytecodeAdapter.castToType((Object)it, CharSequence.class)));
                if (SystemUtils.IS_OS_WINDOWS) {
                    String string;
                    syntaxAndPattern = string = syntaxAndPattern.replace("\\", "\\\\");
                }
                return ((FileSystem)this.fileSystem.get()).getPathMatcher(syntaxAndPattern);
            }

            public FileSystem getFileSystem() {
                return (FileSystem)ScriptBytecodeAdapter.castToType((Object)this.fileSystem.get(), FileSystem.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _processPatterns_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return (Set)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.collect(patterns, (Closure)new _processPatterns_closure1(this, this, fileSystem)), Set.class);
    }

    public ListMultimap<Path, ContractMetadata> findContracts() {
        ArrayListMultimap result = ArrayListMultimap.create();
        this.appendRecursively(this.baseDir, (ListMultimap<Path, ContractMetadata>)result);
        return result;
    }

    private void appendRecursively(File baseDir, ListMultimap<Path, ContractMetadata> result) {
        Reference result2 = new Reference(result);
        Reference files = new Reference((Object)baseDir.listFiles());
        if (!DefaultTypeTransformation.booleanUnbox((Object)((File[])files.get()))) {
            return;
        }
        public class _appendRecursively_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference result;
            private /* synthetic */ Reference files;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _appendRecursively_closure2(Object _outerInstance, Object _thisObject, Reference result, Reference files) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.result = reference2 = result;
                this.files = reference = files;
            }

            public Object doCall(File file, int index) {
                boolean excluded = ((ContractFileScanner)this.getThisObject()).matchesPattern(file, ((ContractFileScanner)this.getThisObject()).excludeMatchers);
                if (!excluded) {
                    boolean contractFile = ((ContractFileScanner)this.getThisObject()).isContractFile(file);
                    boolean included = DefaultTypeTransformation.booleanUnbox((Object)((ContractFileScanner)this.getThisObject()).includeMatcher) ? file.getAbsolutePath().matches(((ContractFileScanner)this.getThisObject()).includeMatcher) : true;
                    if (contractFile && included) {
                        Path path = file.toPath();
                        Integer order = null;
                        if (((ContractFileScanner)this.getThisObject()).hasScenarioFilenamePattern(path)) {
                            int n = index;
                            order = n;
                        }
                        return ((ListMultimap)this.result.get()).put((Object)file.getParentFile().toPath(), (Object)new ContractMetadata(path, ((ContractFileScanner)this.getThisObject()).matchesPattern(file, ((ContractFileScanner)this.getThisObject()).ignoreMatchers), DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)this.files.get(), Object[].class))), order));
                    }
                    ((ContractFileScanner)this.getThisObject()).appendRecursively(file, (ListMultimap<Path, ContractMetadata>)((ListMultimap)ScriptBytecodeAdapter.castToType((Object)this.result.get(), ListMultimap.class)));
                    if (log.isDebugEnabled()) {
                        log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{file, contractFile, included}, new String[]{"File [", "] is ignored. Is a contract file? [", "]. Should be included by pattern? [", "]"})));
                        return null;
                    }
                    return null;
                }
                if (log.isDebugEnabled()) {
                    log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{file, excluded}, new String[]{"File [", "] is ignored. Should be excluded? [", "]"})));
                    return null;
                }
                return null;
            }

            public Object call(File file, int index) {
                return this.doCall(file, index);
            }

            public ListMultimap getResult() {
                return (ListMultimap)ScriptBytecodeAdapter.castToType((Object)this.result.get(), ListMultimap.class);
            }

            public File[] getFiles() {
                return (File[])ScriptBytecodeAdapter.castToType((Object)this.files.get(), File[].class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _appendRecursively_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.eachWithIndex((Object)DefaultGroovyMethods.sort((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)((File[])files.get()), Object[].class))), (Closure)new _appendRecursively_closure2(this, this, result2, files));
    }

    private boolean hasScenarioFilenamePattern(Path path) {
        return SCENARIO_STEP_FILENAME_PATTERN.matcher(path.getFileName().toString()).matches();
    }

    private boolean matchesPattern(File file, Set<PathMatcher> matchers) {
        PathMatcher matcher = null;
        Iterator<PathMatcher> iterator = matchers.iterator();
        while (iterator.hasNext()) {
            matcher = (PathMatcher)ScriptBytecodeAdapter.castToType((Object)iterator.next(), PathMatcher.class);
            if (!matcher.matches(file.toPath())) continue;
            return true;
        }
        return false;
    }

    private boolean isContractFile(File file) {
        String string;
        return file.isFile() && DefaultTypeTransformation.booleanUnbox((string = ContractFileScanner.getFilenameExtension(file.toString())) != null ? Boolean.valueOf(string.equalsIgnoreCase("groovy")) : null);
    }

    private static String getFilenameExtension(String path) {
        if (path == null) {
            return ShortTypeHandling.castToString(null);
        }
        int extIndex = path.lastIndexOf(".");
        if (ScriptBytecodeAdapter.compareEqual((Object)extIndex, (Object)-1)) {
            return ShortTypeHandling.castToString(null);
        }
        int folderIndex = path.lastIndexOf("/");
        if (folderIndex > extIndex) {
            return ShortTypeHandling.castToString(null);
        }
        return path.substring(extIndex + 1);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ContractFileScanner.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        Pattern pattern;
        SCENARIO_STEP_FILENAME_PATTERN = pattern = Pattern.compile("[0-9]+_.*");
        log = logger = LoggerFactory.getLogger((String)"org.springframework.cloud.contract.verifier.file.ContractFileScanner");
    }
}

