/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.util;

import com.toomuchcoding.jsonassert.JsonVerifiable;
import java.util.LinkedList;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.springframework.cloud.contract.verifier.util.FinishedDelegatingJsonVerifiable;
import org.springframework.cloud.contract.verifier.util.MethodBufferingJsonVerifiable;
import org.springframework.cloud.contract.verifier.util.ShouldTraverse;

class DelegatingJsonVerifiable
implements MethodBufferingJsonVerifiable {
    private static final Pattern FIELD_PATTERN = Pattern.compile("\\.field\\((\")?(.)+(\")?\\)");
    private static final Pattern ARRAY_PATTERN = Pattern.compile("\\.array\\((\")?(.)+(\")?\\)");
    final JsonVerifiable delegate;
    final LinkedList<String> methodsBuffer;

    DelegatingJsonVerifiable(JsonVerifiable delegate, LinkedList<String> methodsBuffer) {
        this.delegate = delegate;
        this.methodsBuffer = new LinkedList<String>(methodsBuffer);
    }

    DelegatingJsonVerifiable(JsonVerifiable delegate) {
        this.delegate = delegate;
        this.methodsBuffer = new LinkedList();
    }

    private static String stringWithEscapedQuotes(Object object) {
        String stringValue = object.toString();
        return stringValue.replaceAll("\"", "\\\\\"");
    }

    private static String wrapValueWithQuotes(Object value) {
        return value instanceof String ? "\"" + DelegatingJsonVerifiable.stringWithEscapedQuotes(value) + "\"" : value.toString();
    }

    private void appendMethodWithValue(String methodName, Object value) {
        this.methodsBuffer.offer("." + methodName + "(" + value + ")");
    }

    private void appendMethodWithQuotedValue(String methodName, Object value) {
        this.appendMethodWithValue(methodName, DelegatingJsonVerifiable.wrapValueWithQuotes(value));
    }

    @Override
    public MethodBufferingJsonVerifiable contains(Object value) {
        FinishedDelegatingJsonVerifiable verifiable = new FinishedDelegatingJsonVerifiable(this.delegate.contains(value), this.methodsBuffer);
        super.appendMethodWithQuotedValue("contains", value);
        if (this.isAssertingAValueInArray()) {
            verifiable.methodsBuffer.offer(".value()");
        }
        return verifiable;
    }

    @Override
    public MethodBufferingJsonVerifiable field(Object value) {
        Object valueToPut = value instanceof ShouldTraverse ? ((ShouldTraverse)value).value : value;
        DelegatingJsonVerifiable verifiable = new DelegatingJsonVerifiable(this.delegate.field(valueToPut), this.methodsBuffer);
        if (this.delegate.isIteratingOverArray() && !(value instanceof ShouldTraverse)) {
            verifiable.appendMethodWithQuotedValue("contains", valueToPut);
        } else {
            verifiable.appendMethodWithQuotedValue("field", valueToPut);
        }
        return verifiable;
    }

    public MethodBufferingJsonVerifiable field(String ... strings) {
        MethodBufferingJsonVerifiable verifiable = null;
        for (String string : strings) {
            verifiable = verifiable == null ? this.field((Object)string) : verifiable.field(string);
        }
        return verifiable;
    }

    @Override
    public MethodBufferingJsonVerifiable array(Object value) {
        DelegatingJsonVerifiable verifiable = new DelegatingJsonVerifiable(this.delegate.array(value), this.methodsBuffer);
        verifiable.appendMethodWithQuotedValue("array", value);
        return verifiable;
    }

    @Override
    public MethodBufferingJsonVerifiable arrayField(Object value) {
        DelegatingJsonVerifiable verifiable = new DelegatingJsonVerifiable(this.delegate.field(value).arrayField(), this.methodsBuffer);
        verifiable.appendMethodWithQuotedValue("array", value);
        return verifiable;
    }

    @Override
    public MethodBufferingJsonVerifiable arrayField() {
        DelegatingJsonVerifiable verifiable = new DelegatingJsonVerifiable(this.delegate.arrayField(), this.methodsBuffer);
        verifiable.methodsBuffer.offer(".arrayField()");
        return verifiable;
    }

    @Override
    public MethodBufferingJsonVerifiable array() {
        DelegatingJsonVerifiable verifiable = new DelegatingJsonVerifiable(this.delegate.array(), this.methodsBuffer);
        verifiable.methodsBuffer.offer(".array()");
        return verifiable;
    }

    public JsonVerifiable elementWithIndex(int i) {
        DelegatingJsonVerifiable verifiable = new DelegatingJsonVerifiable(this.delegate.elementWithIndex(i), this.methodsBuffer);
        this.methodsBuffer.offer(".elementWithIndex(" + i + ")");
        return verifiable;
    }

    @Override
    public MethodBufferingJsonVerifiable iterationPassingArray() {
        return new DelegatingJsonVerifiable(this.delegate, this.methodsBuffer);
    }

    @Override
    public MethodBufferingJsonVerifiable isEqualTo(String value) {
        FinishedDelegatingJsonVerifiable readyToCheck = new FinishedDelegatingJsonVerifiable(this.delegate.isEqualTo(value), this.methodsBuffer);
        if (this.delegate.isAssertingAValueInArray() && readyToCheck.methodsBuffer.peekLast().equals(".arrayField()")) {
            super.appendMethodWithQuotedValue("isEqualTo", StringEscapeUtils.escapeJava((String)value));
            readyToCheck.methodsBuffer.offer(".value()");
        } else if (this.delegate.isAssertingAValueInArray() && !readyToCheck.methodsBuffer.peekLast().contains("array")) {
            readyToCheck.methodsBuffer.offer(".value()");
        } else {
            super.appendMethodWithQuotedValue("isEqualTo", StringEscapeUtils.escapeJava((String)value));
        }
        return readyToCheck;
    }

    @Override
    public MethodBufferingJsonVerifiable isEqualTo(Object value) {
        if (value == null) {
            return this.isNull();
        }
        return this.isEqualTo(value.toString());
    }

    @Override
    public MethodBufferingJsonVerifiable isEqualTo(Number value) {
        FinishedDelegatingJsonVerifiable readyToCheck = new FinishedDelegatingJsonVerifiable(this.delegate.isEqualTo(value), this.methodsBuffer);
        String last = readyToCheck.methodsBuffer.peekLast();
        boolean containsAMatcher = this.containsAnyMatcher(last);
        if (this.delegate.isAssertingAValueInArray() && containsAMatcher) {
            readyToCheck.methodsBuffer.offer(".value()");
        } else {
            super.appendMethodWithValue("isEqualTo", String.valueOf(value));
        }
        return readyToCheck;
    }

    private boolean containsAnyMatcher(String string) {
        return string.contains("isEqualTo") || string.contains("matches") || string.contains("isNull");
    }

    @Override
    public MethodBufferingJsonVerifiable isNull() {
        FinishedDelegatingJsonVerifiable readyToCheck = new FinishedDelegatingJsonVerifiable(this.delegate.isNull(), this.methodsBuffer);
        readyToCheck.methodsBuffer.offer(".isNull()");
        return readyToCheck;
    }

    @Override
    public MethodBufferingJsonVerifiable matches(String value) {
        FinishedDelegatingJsonVerifiable readyToCheck = new FinishedDelegatingJsonVerifiable(this.delegate.matches(value), this.methodsBuffer);
        if (this.delegate.isAssertingAValueInArray()) {
            super.appendMethodWithQuotedValue("matches", StringEscapeUtils.escapeJava((String)value));
            readyToCheck.methodsBuffer.offer(".value()");
        } else {
            super.appendMethodWithQuotedValue("matches", StringEscapeUtils.escapeJava((String)value));
        }
        return readyToCheck;
    }

    @Override
    public MethodBufferingJsonVerifiable isEqualTo(Boolean value) {
        FinishedDelegatingJsonVerifiable readyToCheck = new FinishedDelegatingJsonVerifiable(this.delegate.isEqualTo(value), this.methodsBuffer);
        if (this.delegate.isAssertingAValueInArray()) {
            readyToCheck.methodsBuffer.offer(".value()");
        } else {
            super.appendMethodWithValue("isEqualTo", String.valueOf(value));
        }
        return readyToCheck;
    }

    @Override
    public MethodBufferingJsonVerifiable value() {
        return new FinishedDelegatingJsonVerifiable(this.delegate, this.methodsBuffer);
    }

    @Override
    public boolean assertsSize() {
        for (String s : this.methodsBuffer) {
            if (!s.contains(".hasSize(")) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean assertsConcreteValue() {
        for (String s : this.methodsBuffer) {
            if (!FIELD_PATTERN.matcher(s).matches() && !ARRAY_PATTERN.matcher(s).matches()) continue;
            return true;
        }
        return false;
    }

    public JsonVerifiable withoutThrowingException() {
        return this.delegate.withoutThrowingException();
    }

    public String jsonPath() {
        return this.delegate.jsonPath();
    }

    public void matchesJsonPath(String s) {
        this.delegate.matchesJsonPath(s);
    }

    public JsonVerifiable hasSize(int size) {
        FinishedDelegatingJsonVerifiable verifiable = new FinishedDelegatingJsonVerifiable(this.delegate.hasSize(size), this.methodsBuffer);
        verifiable.methodsBuffer.offer(".hasSize(" + size + ")");
        return verifiable;
    }

    public boolean isIteratingOverNamelessArray() {
        return this.delegate.isIteratingOverNamelessArray();
    }

    public boolean isIteratingOverArray() {
        return this.delegate.isIteratingOverArray();
    }

    public boolean isAssertingAValueInArray() {
        return this.delegate.isAssertingAValueInArray();
    }

    @Override
    public String method() {
        return this.createMethodString();
    }

    private String createMethodString() {
        LinkedList<String> queue = new LinkedList<String>(this.methodsBuffer);
        StringBuilder stringBuffer = new StringBuilder();
        while (!queue.isEmpty()) {
            stringBuffer.append(queue.remove());
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DelegatingJsonVerifiable that = (DelegatingJsonVerifiable)o;
        if (this.delegate != null ? !this.delegate.equals(that.delegate) : that.delegate != null) {
            return false;
        }
        if (this.delegate == null) {
            return false;
        }
        if (this.delegate.jsonPath() == null && that.delegate.jsonPath() == null) {
            return true;
        }
        return this.delegate.jsonPath().equals(that.delegate.jsonPath());
    }

    public int hashCode() {
        int result = this.delegate != null ? this.delegate.jsonPath().hashCode() : 0;
        return 31 * result;
    }

    public String toString() {
        return "DelegatingJsonVerifiable{delegate=\n" + this.delegate + ", methodsBuffer=" + this.methodsBuffer + '}';
    }

    public <T> T read(Class<T> aClass) {
        return (T)this.delegate.read(aClass);
    }
}

