/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.messaging.amqp;

import java.util.Map;
import org.springframework.amqp.support.AmqpHeaderMapper;
import org.springframework.amqp.support.SimpleAmqpHeaderMapper;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.amqp.support.converter.MessagingMessageConverter;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifier;
import org.springframework.cloud.contract.verifier.messaging.internal.ContractVerifierMessage;
import org.springframework.cloud.contract.verifier.messaging.internal.ContractVerifierMessaging;
import org.springframework.messaging.Message;

class ContractVerifierHelper
extends ContractVerifierMessaging<org.springframework.amqp.core.Message> {
    private final MessageConverter messageConverter;

    public ContractVerifierHelper(MessageVerifier<org.springframework.amqp.core.Message> exchange, MessageConverter messageConverter) {
        super(exchange);
        this.messageConverter = messageConverter;
    }

    @Override
    protected ContractVerifierMessage convert(org.springframework.amqp.core.Message message) {
        MessagingMessageConverter messageConverter = new MessagingMessageConverter(this.messageConverter, (AmqpHeaderMapper)new SimpleAmqpHeaderMapper());
        Message messagingMessage = (Message)messageConverter.fromMessage(message);
        return new ContractVerifierMessage(messagingMessage.getPayload(), (Map<String, Object>)messagingMessage.getHeaders());
    }
}

