/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import groovy.lang.Closure;
import groovy.lang.GeneratedGroovyProxy;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.util.List;
import java.util.Optional;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.transform.trait.Traits;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.spec.internal.BodyMatcher;
import org.springframework.cloud.contract.spec.internal.BodyMatchers;
import org.springframework.cloud.contract.spec.internal.ExecutionProperty;
import org.springframework.cloud.contract.spec.internal.MatchingType;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.BodyMethodGeneration;
import org.springframework.cloud.contract.verifier.util.xml.XmlToXPathsConverter;

class XmlBodyVerificationBuilder
implements BodyMethodGeneration,
GroovyObject {
    private final Contract contract;
    private final Optional<String> lineSuffix;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public XmlBodyVerificationBuilder(Contract contract, Optional<String> lineSuffix) {
        Contract contract2;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        BodyMethodGeneration.Trait.Helper.$init$(this);
        this.contract = contract2 = contract;
        Optional<String> optional = lineSuffix;
        this.lineSuffix = optional;
    }

    public void addXmlResponseBodyCheck(BlockBuilder blockBuilder, Object responseBody, BodyMatchers bodyMatchers, String responseString, boolean shouldCommentOutBDDBlocks) {
        this.addXmlProcessingLines(blockBuilder, responseString);
        Object processedBody = XmlToXPathsConverter.removeMatchingXPaths(responseBody, bodyMatchers);
        List<BodyMatcher> matchers = XmlToXPathsConverter.mapToMatchers(processedBody);
        BodyMatchers bodyMatchers2 = bodyMatchers;
        Boolean bl = bodyMatchers2 != null ? Boolean.valueOf(bodyMatchers2.hasMatchers()) : null;
        if (bl == null ? false : bl) {
            matchers.addAll(bodyMatchers.matchers());
        }
        this.addBodyMatchingBlock(matchers, blockBuilder, responseBody, shouldCommentOutBDDBlocks);
    }

    private void addXmlProcessingLines(BlockBuilder blockBuilder, String responseString) {
        Reference blockBuilder2 = new Reference((Object)blockBuilder);
        public class _addXmlProcessingLines_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference blockBuilder;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _addXmlProcessingLines_closure1(Object _outerInstance, Object _thisObject, Reference blockBuilder) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.blockBuilder = reference = blockBuilder;
            }

            public Object doCall(Object it) {
                ((BlockBuilder)this.blockBuilder.get()).addLine((String)ScriptBytecodeAdapter.asType((Object)it, String.class));
                ((XmlBodyVerificationBuilder)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), XmlBodyVerificationBuilder.class)).addColonIfRequired(((XmlBodyVerificationBuilder)this.getThisObject()).lineSuffix, (BlockBuilder)ScriptBytecodeAdapter.castToType((Object)this.blockBuilder.get(), BlockBuilder.class));
                return null;
            }

            public BlockBuilder getBlockBuilder() {
                return (BlockBuilder)ScriptBytecodeAdapter.castToType((Object)this.blockBuilder.get(), BlockBuilder.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _addXmlProcessingLines_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each((List)ScriptBytecodeAdapter.createList((Object[])new Object[]{"DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder()", new GStringImpl(new Object[]{responseString}, new String[]{"Document parsedXml = documentBuilder.parse(new InputSource(new StringReader(", ")))"})}), (Closure)new _addXmlProcessingLines_closure1(this, this, blockBuilder2));
    }

    @Override
    public void methodForNullCheck(BodyMatcher bodyMatcher, BlockBuilder bb) {
        String quotedAndEscapedPath = this.quotedAndEscaped(bodyMatcher.path());
        String method = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{quotedAndEscapedPath}, new String[]{"assertThat(nodeFromXPath(parsedXml, ", ")).isNull()"}));
        bb.addLine(method.replace("$", "\\$"));
        this.addColonIfRequired(this.lineSuffix, bb);
    }

    @Override
    public void methodForEqualityCheck(BodyMatcher bodyMatcher, BlockBuilder bb, Object body) {
        String retrievedValue = this.quotedAndEscaped(XmlToXPathsConverter.retrieveValue(bodyMatcher, body));
        String comparisonMethod = ScriptBytecodeAdapter.compareEqual((Object)bodyMatcher.matchingType(), (Object)MatchingType.EQUALITY) ? "isEqualTo" : "matches";
        String method = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.quotedAndEscaped(bodyMatcher.path()), comparisonMethod, retrievedValue}, new String[]{"assertThat(valueFromXPath(parsedXml, ", ")).", "(", ")"}));
        bb.addLine(method.replace("$", "\\$"));
        this.addColonIfRequired(this.lineSuffix, bb);
    }

    @Override
    public void methodForCommandExecution(BodyMatcher bodyMatcher, BlockBuilder bb, Object body) {
        String retrievedValue = this.quotedAndEscaped(XmlToXPathsConverter.retrieveValueFromBody(bodyMatcher.path(), body));
        ExecutionProperty property = (ExecutionProperty)ScriptBytecodeAdapter.asType((Object)bodyMatcher.value(), ExecutionProperty.class);
        bb.addLine(property.insertValue(retrievedValue.replace("$", "\\$")));
        this.addColonIfRequired(this.lineSuffix, bb);
    }

    @Override
    public void methodForTypeCheck(BodyMatcher bodyMatcher, BlockBuilder bb, Object copiedBody) {
        throw (Throwable)new UnsupportedOperationException("The `getNodeValue()` method in `org.w3c.dom.Node` always returns String.");
    }

    @Override
    @Traits.TraitBridge(traitClass=BodyMethodGeneration.class, desc="(Ljava/lang/Object;)Ljava/lang/Object;")
    public Object cloneBody(Object arg1) {
        return BodyMethodGeneration.Trait.Helper.cloneBody(this, arg1);
    }

    public /* synthetic */ Object org_springframework_cloud_contract_verifier_builder_BodyMethodGenerationtrait$super$cloneBody(Object object) {
        if (this instanceof GeneratedGroovyProxy) {
            return InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"cloneBody", (Object)new Object[]{object});
        }
        return ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"cloneBody", (Object[])new Object[]{object});
    }

    @Override
    @Traits.TraitBridge(traitClass=BodyMethodGeneration.class, desc="(Ljava/util/Optional;Lorg/springframework/cloud/contract/verifier/builder/BlockBuilder;)V")
    public void addColonIfRequired(Optional<String> arg1, BlockBuilder arg2) {
        BodyMethodGeneration.Trait.Helper.addColonIfRequired(this, arg1, arg2);
    }

    public /* synthetic */ void org_springframework_cloud_contract_verifier_builder_BodyMethodGenerationtrait$super$addColonIfRequired(Optional<String> lineSuffix, BlockBuilder blockBuilder) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"addColonIfRequired", (Object)new Object[]{lineSuffix, blockBuilder});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"addColonIfRequired", (Object[])new Object[]{lineSuffix, blockBuilder});
        }
    }

    @Override
    @Traits.TraitBridge(traitClass=BodyMethodGeneration.class, desc="(Ljava/util/List;Lorg/springframework/cloud/contract/verifier/builder/BlockBuilder;Ljava/lang/Object;Z)V")
    public void addBodyMatchingBlock(List<BodyMatcher> arg1, BlockBuilder arg2, Object arg3, boolean arg4) {
        BodyMethodGeneration.Trait.Helper.addBodyMatchingBlock(this, arg1, arg2, arg3, arg4);
    }

    public /* synthetic */ void org_springframework_cloud_contract_verifier_builder_BodyMethodGenerationtrait$super$addBodyMatchingBlock(List<BodyMatcher> matchers, BlockBuilder blockBuilder, Object responseBody, boolean shouldCommentOutBDDBlocks) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"addBodyMatchingBlock", (Object)new Object[]{matchers, blockBuilder, responseBody, shouldCommentOutBDDBlocks});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"addBodyMatchingBlock", (Object[])new Object[]{matchers, blockBuilder, responseBody, shouldCommentOutBDDBlocks});
        }
    }

    @Override
    @Traits.TraitBridge(traitClass=BodyMethodGeneration.class, desc="(Ljava/lang/String;)Ljava/lang/String;")
    public String quotedAndEscaped(String arg1) {
        return BodyMethodGeneration.Trait.Helper.quotedAndEscaped(this, arg1);
    }

    public /* synthetic */ String org_springframework_cloud_contract_verifier_builder_BodyMethodGenerationtrait$super$quotedAndEscaped(String string) {
        if (this instanceof GeneratedGroovyProxy) {
            return ShortTypeHandling.castToString((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"quotedAndEscaped", (Object)new Object[]{string}));
        }
        return ShortTypeHandling.castToString((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"quotedAndEscaped", (Object[])new Object[]{string}));
    }

    @Override
    @Traits.TraitBridge(traitClass=BodyMethodGeneration.class, desc="(Z)Ljava/lang/String;")
    public String getAssertionJoiner(boolean arg1) {
        return BodyMethodGeneration.Trait.Helper.getAssertionJoiner(this, arg1);
    }

    public /* synthetic */ String org_springframework_cloud_contract_verifier_builder_BodyMethodGenerationtrait$super$getAssertionJoiner(boolean shouldCommentOutBDDBlocks) {
        if (this instanceof GeneratedGroovyProxy) {
            return ShortTypeHandling.castToString((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getAssertionJoiner", (Object)new Object[]{shouldCommentOutBDDBlocks}));
        }
        return ShortTypeHandling.castToString((Object)ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"getAssertionJoiner", (Object[])new Object[]{shouldCommentOutBDDBlocks}));
    }

    static {
        BodyMethodGeneration.Trait.Helper.$static$init$(XmlBodyVerificationBuilder.class);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != XmlBodyVerificationBuilder.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }
}

