/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.springframework.cloud.contract.verifier.builder.SingleTestGenerator;
import org.springframework.cloud.contract.verifier.util.NamesUtil;

class FileSaver
implements GroovyObject {
    private final File targetDirectory;
    private final SingleTestGenerator generator;
    private final String fileExtension;
    private static final transient Log log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public FileSaver(File targetDirectory, String fileExtension, SingleTestGenerator generator) {
        String string;
        SingleTestGenerator singleTestGenerator;
        File file;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.targetDirectory = file = targetDirectory;
        this.generator = singleTestGenerator = generator;
        this.fileExtension = string = fileExtension;
    }

    public void saveClassFile(Path classPath, byte ... classBytes) {
        Object v0;
        if (log.isInfoEnabled()) {
            log.info((Object)new GStringImpl(new Object[]{classPath}, new String[]{"Creating new class file [", "]"}));
            v0 = null;
        } else {
            v0 = null;
        }
        Files.write(classPath, classBytes, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    protected Path pathToClass(Path testBaseDir, String fileName) {
        return Paths.get(testBaseDir.toString(), StringGroovyMethods.plus((String)NamesUtil.capitalize(fileName), (CharSequence)this.fileExtension)).toAbsolutePath();
    }

    protected Path generateTestBaseDir(String basePackageClass, String includedDirectoryRelativePath) {
        Path testBaseDir = Paths.get(this.targetDirectory.getAbsolutePath(), NamesUtil.packageToDirectory(basePackageClass), NamesUtil.beforeLast(includedDirectoryRelativePath, File.separator));
        Files.createDirectories(testBaseDir, new FileAttribute[0]);
        return testBaseDir;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != FileSaver.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Log log;
        FileSaver.log = log = LogFactory.getLog((String)"org.springframework.cloud.contract.verifier.FileSaver");
    }
}

