/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.BodyMethodVisitor;
import org.springframework.cloud.contract.verifier.builder.BodyParser;
import org.springframework.cloud.contract.verifier.builder.ExplicitResponseWhen;
import org.springframework.cloud.contract.verifier.builder.GeneratedClassMetaData;
import org.springframework.cloud.contract.verifier.builder.MethodVisitor;
import org.springframework.cloud.contract.verifier.builder.MockMvcAsyncWhen;
import org.springframework.cloud.contract.verifier.builder.MockMvcQueryParamsWhen;
import org.springframework.cloud.contract.verifier.builder.MockMvcResponseWhen;
import org.springframework.cloud.contract.verifier.builder.MockMvcUrlWhen;
import org.springframework.cloud.contract.verifier.builder.SpockMockMvcResponseWhen;
import org.springframework.cloud.contract.verifier.builder.WebTestClientResponseWhen;
import org.springframework.cloud.contract.verifier.builder.When;
import org.springframework.cloud.contract.verifier.config.TestMode;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;

class RestAssuredWhen
implements When,
BodyMethodVisitor {
    private final BlockBuilder blockBuilder;
    private final GeneratedClassMetaData generatedClassMetaData;
    private final List<When> responseWhens = new LinkedList<When>();
    private final List<When> whens = new LinkedList<When>();

    RestAssuredWhen(BlockBuilder blockBuilder, GeneratedClassMetaData generatedClassMetaData, BodyParser bodyParser) {
        this.blockBuilder = blockBuilder;
        this.generatedClassMetaData = generatedClassMetaData;
        this.responseWhens.addAll(Arrays.asList(new MockMvcResponseWhen(blockBuilder, this.generatedClassMetaData), new SpockMockMvcResponseWhen(blockBuilder, this.generatedClassMetaData), new ExplicitResponseWhen(blockBuilder, this.generatedClassMetaData), new WebTestClientResponseWhen(blockBuilder, this.generatedClassMetaData)));
        this.whens.addAll(Arrays.asList(new MockMvcQueryParamsWhen(this.blockBuilder, bodyParser), new MockMvcAsyncWhen(this.blockBuilder, this.generatedClassMetaData), new MockMvcUrlWhen(this.blockBuilder, bodyParser)));
    }

    @Override
    public MethodVisitor<When> apply(SingleContractMetadata singleContractMetadata) {
        this.startBodyBlock(this.blockBuilder, "when:");
        this.addResponseWhenLine(singleContractMetadata);
        this.indentedBodyBlock(this.blockBuilder, this.whens, singleContractMetadata);
        this.blockBuilder.addEmptyLine();
        return this;
    }

    private void addResponseWhenLine(SingleContractMetadata singleContractMetadata) {
        this.responseWhens.stream().filter(when -> when.accept(singleContractMetadata)).findFirst().orElseThrow(() -> new IllegalStateException("No matching request building When implementation for Rest Assured")).apply(singleContractMetadata);
    }

    @Override
    public boolean accept(SingleContractMetadata singleContractMetadata) {
        return singleContractMetadata.isHttp() && this.generatedClassMetaData.configProperties.getTestMode() != TestMode.JAXRSCLIENT;
    }
}

