/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.config;

import java.util.List;
import org.springframework.cloud.contract.verifier.config.framework.CustomDefinition;
import org.springframework.cloud.contract.verifier.config.framework.JUnit5Definition;
import org.springframework.cloud.contract.verifier.config.framework.JUnitDefinition;
import org.springframework.cloud.contract.verifier.config.framework.SpockDefinition;
import org.springframework.cloud.contract.verifier.config.framework.TestFrameworkDefinition;
import org.springframework.cloud.contract.verifier.config.framework.TestNGDefinition;

public enum TestFramework {
    SPOCK(new SpockDefinition()),
    JUNIT(new JUnitDefinition()),
    JUNIT5(new JUnit5Definition()),
    TESTNG(new TestNGDefinition()),
    CUSTOM(new CustomDefinition());

    private final TestFrameworkDefinition testFrameworkDefinition;

    private TestFramework(TestFrameworkDefinition testFrameworkDefinition) {
        this.testFrameworkDefinition = testFrameworkDefinition;
    }

    @Deprecated
    private TestFramework(final String classModifier, final String methodModifier, final String lineSuffix, final String classExtension, final String classNameSuffix, final String ignoreClass, final List<String> orderAnnotationImports, final String orderAnnotation) {
        this.testFrameworkDefinition = new TestFrameworkDefinition(){

            @Override
            public String getClassModifier() {
                return classModifier;
            }

            @Override
            public String getMethodModifier() {
                return methodModifier;
            }

            @Override
            public String getLineSuffix() {
                return lineSuffix;
            }

            @Override
            public String getClassExtension() {
                return classExtension;
            }

            @Override
            public String getClassNameSuffix() {
                return classNameSuffix;
            }

            @Override
            public String getIgnoreClass() {
                return ignoreClass;
            }

            @Override
            public List<String> getOrderAnnotationImports() {
                return orderAnnotationImports;
            }

            @Override
            public String getOrderAnnotation() {
                return orderAnnotation;
            }

            @Override
            public String getIgnoreAnnotation() {
                return "@Ignore";
            }

            @Override
            public boolean annotationLevelRules() {
                return false;
            }

            @Override
            public String getRuleAnnotation(String annotationValue) {
                throw new UnsupportedOperationException("Not available in framework.");
            }
        };
    }

    public String getClassModifier() {
        return this.testFrameworkDefinition.getClassModifier();
    }

    public String getMethodModifier() {
        return this.testFrameworkDefinition.getMethodModifier();
    }

    public String getLineSuffix() {
        return this.testFrameworkDefinition.getLineSuffix();
    }

    public String getClassExtension() {
        return this.testFrameworkDefinition.getClassExtension();
    }

    public String getClassNameSuffix() {
        return this.testFrameworkDefinition.getClassNameSuffix();
    }

    public String getIgnoreClass() {
        return this.testFrameworkDefinition.getIgnoreClass();
    }

    public List<String> getOrderAnnotationImports() {
        return this.testFrameworkDefinition.getOrderAnnotationImports();
    }

    public String getOrderAnnotation() {
        return this.testFrameworkDefinition.getOrderAnnotation();
    }

    public String getIgnoreAnnotation() {
        return this.testFrameworkDefinition.getIgnoreAnnotation();
    }

    public boolean annotationLevelRules() {
        return this.testFrameworkDefinition.annotationLevelRules();
    }

    public String getRuleAnnotation(String annotationValue) {
        return this.testFrameworkDefinition.getRuleAnnotation(annotationValue);
    }
}

