/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.messaging.amqp;

import java.util.Collections;
import java.util.List;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.listener.RabbitListenerEndpointRegistry;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.test.mock.mockito.SpyBean;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifier;
import org.springframework.cloud.contract.verifier.messaging.amqp.ContractVerifierHelper;
import org.springframework.cloud.contract.verifier.messaging.amqp.MessageListenerAccessor;
import org.springframework.cloud.contract.verifier.messaging.amqp.SpringAmqpStubMessages;
import org.springframework.cloud.contract.verifier.messaging.integration.ContractVerifierIntegrationConfiguration;
import org.springframework.cloud.contract.verifier.messaging.internal.ContractVerifierMessaging;
import org.springframework.cloud.contract.verifier.messaging.stream.ContractVerifierStreamAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={RabbitTemplate.class})
@ConditionalOnProperty(name={"stubrunner.amqp.enabled"}, havingValue="true")
@AutoConfigureBefore(value={ContractVerifierIntegrationConfiguration.class})
@AutoConfigureAfter(value={ContractVerifierStreamAutoConfiguration.class})
public class ContractVerifierAmqpAutoConfiguration {
    @SpyBean
    private RabbitTemplate rabbitTemplate;
    @Autowired(required=false)
    private RabbitListenerEndpointRegistry rabbitListenerEndpointRegistry;
    @Autowired(required=false)
    private List<SimpleMessageListenerContainer> simpleMessageListenerContainers = Collections.emptyList();
    @Autowired(required=false)
    private List<Binding> bindings = Collections.emptyList();
    @Autowired
    private RabbitProperties rabbitProperties;

    @Bean
    @ConditionalOnMissingBean
    public MessageVerifier<Message> contractVerifierMessageExchange() {
        return new SpringAmqpStubMessages(this.rabbitTemplate, new MessageListenerAccessor(this.rabbitListenerEndpointRegistry, this.simpleMessageListenerContainers, this.bindings), this.rabbitProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    public ContractVerifierMessaging<Message> contractVerifierMessaging(MessageVerifier<Message> exchange) {
        return new ContractVerifierHelper(exchange, this.rabbitTemplate.getMessageConverter());
    }
}

