/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.messaging.stream;

import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifierReceiver;
import org.springframework.cloud.contract.verifier.messaging.stream.DefaultChannels;
import org.springframework.cloud.contract.verifier.messaging.stream.DestinationResolver;
import org.springframework.cloud.stream.test.binder.MessageCollector;
import org.springframework.context.ApplicationContext;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;

class StreamMessageCollectorMessageReceiver
implements MessageVerifierReceiver<Message<?>> {
    private static final Log log = LogFactory.getLog(StreamMessageCollectorMessageReceiver.class);
    private final DestinationResolver resolver;
    private MessageCollector messageCollector;
    private final ApplicationContext context;

    StreamMessageCollectorMessageReceiver(DestinationResolver resolver, ApplicationContext context) {
        this.resolver = resolver;
        this.context = context;
    }

    @Override
    public Message<?> receive(String destination, long timeout, TimeUnit timeUnit) {
        try {
            MessageChannel messageChannel = (MessageChannel)this.context.getBean(this.resolver.resolvedDestination(destination, DefaultChannels.INPUT), MessageChannel.class);
            return (Message)this.messageCollector().forChannel(messageChannel).poll(timeout, timeUnit);
        }
        catch (Exception e) {
            log.error((Object)("Exception occurred while trying to read a message from  a channel with name [" + destination + "]"), (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    private MessageCollector messageCollector() {
        if (this.messageCollector == null) {
            this.messageCollector = (MessageCollector)this.context.getBean(MessageCollector.class);
        }
        return this.messageCollector;
    }

    @Override
    public Message<?> receive(String destination) {
        return this.receive(destination, 5L, TimeUnit.SECONDS);
    }
}

