/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.messaging.stream;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifierSender;
import org.springframework.cloud.contract.verifier.messaging.stream.ContractVerifierStreamMessageBuilder;
import org.springframework.cloud.stream.binding.BinderAwareChannelResolver;
import org.springframework.context.ApplicationContext;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;

class StreamStubMessageSender
implements MessageVerifierSender<Message<?>> {
    private static final Log log = LogFactory.getLog(StreamStubMessageSender.class);
    private final ApplicationContext context;
    private final ContractVerifierStreamMessageBuilder builder = new ContractVerifierStreamMessageBuilder();
    private BinderAwareChannelResolver resolver;

    StreamStubMessageSender(ApplicationContext context) {
        this.context = context;
    }

    @Override
    public <T> void send(T payload, Map<String, Object> headers, String destination) {
        this.send(this.builder.create(payload, headers), destination);
    }

    @Override
    public void send(Message<?> message, String destination) {
        try {
            MessageChannel messageChannel = this.resolver().resolveDestination(destination);
            messageChannel.send(message);
        }
        catch (Exception e) {
            log.error((Object)("Exception occurred while trying to send a message [" + message + "] to a channel with name [" + destination + "]"), (Throwable)e);
            throw e;
        }
    }

    private BinderAwareChannelResolver resolver() {
        if (this.resolver == null) {
            this.resolver = (BinderAwareChannelResolver)this.context.getBean(BinderAwareChannelResolver.class);
        }
        return this.resolver;
    }
}

