/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.BodyMethodVisitor;
import org.springframework.cloud.contract.verifier.builder.BodyParser;
import org.springframework.cloud.contract.verifier.builder.ExplicitRequestGiven;
import org.springframework.cloud.contract.verifier.builder.GeneratedClassMetaData;
import org.springframework.cloud.contract.verifier.builder.Given;
import org.springframework.cloud.contract.verifier.builder.MethodVisitor;
import org.springframework.cloud.contract.verifier.builder.MockMvcBodyGiven;
import org.springframework.cloud.contract.verifier.builder.MockMvcCookiesGiven;
import org.springframework.cloud.contract.verifier.builder.MockMvcHeadersGiven;
import org.springframework.cloud.contract.verifier.builder.MockMvcMultipartGiven;
import org.springframework.cloud.contract.verifier.builder.MockMvcRequestGiven;
import org.springframework.cloud.contract.verifier.builder.SpockMockMvcMultipartGiven;
import org.springframework.cloud.contract.verifier.builder.SpockMockMvcRequestGiven;
import org.springframework.cloud.contract.verifier.builder.WebTestClientRequestGiven;
import org.springframework.cloud.contract.verifier.config.TestMode;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;

class RestAssuredGiven
implements Given,
BodyMethodVisitor {
    private final BlockBuilder blockBuilder;
    private final GeneratedClassMetaData generatedClassMetaData;
    private final List<Given> requestGivens = new LinkedList<Given>();
    private final List<Given> bodyGivens = new LinkedList<Given>();

    RestAssuredGiven(BlockBuilder blockBuilder, GeneratedClassMetaData generatedClassMetaData, BodyParser bodyParser) {
        this.blockBuilder = blockBuilder;
        this.generatedClassMetaData = generatedClassMetaData;
        this.requestGivens.addAll(Arrays.asList(new MockMvcRequestGiven(blockBuilder, generatedClassMetaData), new SpockMockMvcRequestGiven(blockBuilder, generatedClassMetaData), new ExplicitRequestGiven(blockBuilder, generatedClassMetaData), new WebTestClientRequestGiven(blockBuilder, generatedClassMetaData)));
        this.bodyGivens.addAll(Arrays.asList(new MockMvcHeadersGiven(blockBuilder), new MockMvcCookiesGiven(blockBuilder), new MockMvcBodyGiven(blockBuilder, generatedClassMetaData, bodyParser), new MockMvcMultipartGiven(blockBuilder, generatedClassMetaData, bodyParser), new SpockMockMvcMultipartGiven(blockBuilder, generatedClassMetaData, bodyParser)));
    }

    @Override
    public MethodVisitor<Given> apply(SingleContractMetadata singleContractMetadata) {
        this.startBodyBlock(this.blockBuilder, "given:");
        this.addRequestGivenLine(singleContractMetadata);
        this.indentedBodyBlock(this.blockBuilder, this.bodyGivens, singleContractMetadata);
        this.blockBuilder.addEmptyLine();
        return this;
    }

    private void addRequestGivenLine(SingleContractMetadata singleContractMetadata) {
        this.requestGivens.stream().filter(given -> given.accept(singleContractMetadata)).findFirst().orElseThrow(() -> new IllegalStateException("No matching request building Given implementation for Rest Assured")).apply(singleContractMetadata);
    }

    @Override
    public boolean accept(SingleContractMetadata singleContractMetadata) {
        return singleContractMetadata.isHttp() && this.generatedClassMetaData.configProperties.getTestMode() != TestMode.JAXRSCLIENT;
    }
}

