/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.messaging.kafka;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifier;
import org.springframework.cloud.contract.verifier.messaging.integration.ContractVerifierIntegrationConfiguration;
import org.springframework.cloud.contract.verifier.messaging.internal.ContractVerifierMessaging;
import org.springframework.cloud.contract.verifier.messaging.kafka.ContractVerifierKafkaHelper;
import org.springframework.cloud.contract.verifier.messaging.kafka.ContractVerifierKafkaStubMessagesInitializer;
import org.springframework.cloud.contract.verifier.messaging.kafka.KafkaStubMessages;
import org.springframework.cloud.contract.verifier.messaging.kafka.KafkaStubMessagesInitializer;
import org.springframework.cloud.contract.verifier.messaging.noop.NoOpContractVerifierAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.test.EmbeddedKafkaBroker;
import org.springframework.messaging.Message;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={KafkaTemplate.class, EmbeddedKafkaBroker.class})
@ConditionalOnProperty(name={"stubrunner.kafka.enabled"}, havingValue="true", matchIfMissing=true)
@AutoConfigureBefore(value={ContractVerifierIntegrationConfiguration.class, NoOpContractVerifierAutoConfiguration.class})
@ConditionalOnBean(value={EmbeddedKafkaBroker.class})
public class ContractVerifierKafkaConfiguration {
    private static final Log log = LogFactory.getLog(ContractVerifierKafkaConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    MessageVerifier<Message<?>> contractVerifierKafkaMessageExchange(KafkaTemplate kafkaTemplate, EmbeddedKafkaBroker broker, KafkaProperties kafkaProperties, KafkaStubMessagesInitializer initializer) {
        return new KafkaStubMessages(kafkaTemplate, broker, kafkaProperties, initializer);
    }

    @Bean
    @ConditionalOnMissingBean
    KafkaStubMessagesInitializer contractVerifierKafkaStubMessagesInitializer() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Registering contract verifier stub messages initializer");
        }
        return new ContractVerifierKafkaStubMessagesInitializer();
    }

    @Bean
    @ConditionalOnMissingBean
    ContractVerifierMessaging<Message<?>> contractVerifierKafkaMessaging(MessageVerifier<Message<?>> exchange) {
        return new ContractVerifierKafkaHelper(exchange);
    }
}

