/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import java.util.Arrays;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.GeneratedClassMetaData;
import org.springframework.cloud.contract.verifier.builder.Imports;
import org.springframework.cloud.contract.verifier.builder.RestAssuredVerifier;
import org.springframework.cloud.contract.verifier.config.TestMode;

class ExplicitRestAssuredStaticImports
implements Imports,
RestAssuredVerifier {
    private final BlockBuilder blockBuilder;
    private final GeneratedClassMetaData generatedClassMetaData;
    private static final String[] REST_ASSURED_2_IMPORTS = new String[]{"com.jayway.restassured.RestAssured.*"};
    private static final String[] REST_ASSURED_3_IMPORTS = new String[]{"io.restassured.RestAssured.*"};

    ExplicitRestAssuredStaticImports(BlockBuilder blockBuilder, GeneratedClassMetaData generatedClassMetaData) {
        this.blockBuilder = blockBuilder;
        this.generatedClassMetaData = generatedClassMetaData;
    }

    @Override
    public Imports call() {
        Arrays.stream(this.isRestAssured2Present() ? REST_ASSURED_2_IMPORTS : REST_ASSURED_3_IMPORTS).forEach(s -> this.blockBuilder.addLineWithEnding("import static " + s));
        return this;
    }

    @Override
    public boolean accept() {
        return this.generatedClassMetaData.configProperties.getTestMode() == TestMode.EXPLICIT && this.generatedClassMetaData.isAnyHttp();
    }
}

