/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import org.springframework.cloud.contract.spec.internal.Response;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.ComparisonBuilder;
import org.springframework.cloud.contract.verifier.builder.CookieElementProcessor;
import org.springframework.cloud.contract.verifier.builder.CustomModeAcceptor;
import org.springframework.cloud.contract.verifier.builder.MethodVisitor;
import org.springframework.cloud.contract.verifier.builder.Then;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;

class CustomModeCookiesThen
implements Then,
CustomModeAcceptor,
CookieElementProcessor {
    private final BlockBuilder blockBuilder;
    private final ComparisonBuilder comparisonBuilder;

    CustomModeCookiesThen(BlockBuilder blockBuilder, ComparisonBuilder comparisonBuilder) {
        this.blockBuilder = blockBuilder;
        this.comparisonBuilder = comparisonBuilder;
    }

    @Override
    public MethodVisitor<Then> apply(SingleContractMetadata metadata) {
        this.processCookies(metadata);
        return this;
    }

    @Override
    public ComparisonBuilder comparisonBuilder() {
        return this.comparisonBuilder;
    }

    @Override
    public BlockBuilder blockBuilder() {
        return this.blockBuilder;
    }

    @Override
    public String cookieKey(String key) {
        return "response.cookie(\"" + key + "\")";
    }

    @Override
    public boolean accept(SingleContractMetadata metadata) {
        Response response = metadata.getContract().getResponse();
        return response.getCookies() != null;
    }
}

