/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import java.util.regex.Pattern;
import org.springframework.cloud.contract.spec.internal.ExecutionProperty;
import org.springframework.cloud.contract.spec.internal.NotToEscapePattern;
import org.springframework.cloud.contract.spec.internal.OutputMessage;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.BodyMethodVisitor;
import org.springframework.cloud.contract.verifier.builder.ComparisonBuilder;
import org.springframework.cloud.contract.verifier.builder.GeneratedClassMetaData;
import org.springframework.cloud.contract.verifier.builder.MethodVisitor;
import org.springframework.cloud.contract.verifier.builder.Then;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;
import org.springframework.cloud.contract.verifier.util.MapConverter;

class MessagingHeadersThen
implements Then,
BodyMethodVisitor {
    private final BlockBuilder blockBuilder;
    private final GeneratedClassMetaData generatedClassMetaData;
    private final ComparisonBuilder comparisonBuilder;

    MessagingHeadersThen(BlockBuilder blockBuilder, GeneratedClassMetaData generatedClassMetaData, ComparisonBuilder comparisonBuilder) {
        this.blockBuilder = blockBuilder;
        this.generatedClassMetaData = generatedClassMetaData;
        this.comparisonBuilder = comparisonBuilder;
    }

    @Override
    public MethodVisitor<Then> apply(SingleContractMetadata singleContractMetadata) {
        this.endBodyBlock(this.blockBuilder);
        this.startBodyBlock(this.blockBuilder, "and:");
        OutputMessage outputMessage = singleContractMetadata.getContract().getOutputMessage();
        outputMessage.getHeaders().executeForEachHeader(header -> this.processHeaderElement(header.getName(), header.getServerValue() instanceof NotToEscapePattern ? header.getServerValue() : MapConverter.getTestSideValues(header.getServerValue())));
        return this;
    }

    private void appendLineWithHeaderNotNull(String property) {
        this.blockBuilder.addLineWithEnding(this.comparisonBuilder.assertThatIsNotNull("response.getHeader(\"" + property + "\")"));
    }

    private void processHeaderElement(String property, Object value) {
        if (value instanceof Number) {
            this.processHeaderElement(property, (Number)value);
        } else if (value instanceof Pattern) {
            this.processHeaderElement(property, (Pattern)value);
        } else if (value instanceof ExecutionProperty) {
            this.processHeaderElement(property, (ExecutionProperty)value);
        } else {
            this.processHeaderElement(property, value.toString());
        }
    }

    private void processHeaderElement(String property, String value) {
        this.appendLineWithHeaderNotNull(property);
        this.blockBuilder.addLineWithEnding(this.comparisonBuilder.assertThat("response.getHeader(\"" + property + "\").toString()", value));
    }

    private void processHeaderElement(String property, Number value) {
        this.appendLineWithHeaderNotNull(property);
        this.blockBuilder.addLineWithEnding(this.comparisonBuilder.assertThat("response.getHeader(\"" + property + "\")", value));
    }

    private void processHeaderElement(String property, Pattern pattern) {
        this.appendLineWithHeaderNotNull(property);
        this.blockBuilder.addLineWithEnding(this.comparisonBuilder.assertThat("response.getHeader(\"" + property + "\").toString()", pattern));
    }

    private void processHeaderElement(String property, ExecutionProperty exec) {
        this.appendLineWithHeaderNotNull(property);
        this.blockBuilder.addLineWithEnding(exec.insertValue("response.getHeader(\"" + property + "\").toString()"));
    }

    @Override
    public boolean accept(SingleContractMetadata singleContractMetadata) {
        return singleContractMetadata.isMessaging() && singleContractMetadata.getContract().getOutputMessage().getHeaders() != null;
    }
}

