/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.BodyMethodVisitor;
import org.springframework.cloud.contract.verifier.builder.GeneratedClassMetaData;
import org.springframework.cloud.contract.verifier.builder.MessagingAssertThatWhen;
import org.springframework.cloud.contract.verifier.builder.MessagingBodyWhen;
import org.springframework.cloud.contract.verifier.builder.MessagingTriggeredByWhen;
import org.springframework.cloud.contract.verifier.builder.MethodVisitor;
import org.springframework.cloud.contract.verifier.builder.When;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;

class MessagingWhen
implements When,
BodyMethodVisitor {
    private final BlockBuilder blockBuilder;
    private final List<When> whens = new LinkedList<When>();

    MessagingWhen(BlockBuilder blockBuilder, GeneratedClassMetaData generatedClassMetaData) {
        this.blockBuilder = blockBuilder;
        this.whens.addAll(Arrays.asList(new MessagingTriggeredByWhen(this.blockBuilder), new MessagingBodyWhen(this.blockBuilder, generatedClassMetaData), new MessagingAssertThatWhen(this.blockBuilder)));
    }

    @Override
    public MethodVisitor<When> apply(SingleContractMetadata singleContractMetadata) {
        this.startBodyBlock(this.blockBuilder, "when:");
        this.bodyBlock(this.blockBuilder, this.whens, singleContractMetadata);
        this.blockBuilder.addEmptyLine();
        return this;
    }

    @Override
    public boolean accept(SingleContractMetadata singleContractMetadata) {
        return singleContractMetadata.isMessaging();
    }
}

