/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.BodyMethodVisitor;
import org.springframework.cloud.contract.verifier.builder.BodyParser;
import org.springframework.cloud.contract.verifier.builder.BodyReader;
import org.springframework.cloud.contract.verifier.builder.GeneratedClassMetaData;
import org.springframework.cloud.contract.verifier.builder.Given;
import org.springframework.cloud.contract.verifier.builder.MessagingBodyGiven;
import org.springframework.cloud.contract.verifier.builder.MessagingHeadersGiven;
import org.springframework.cloud.contract.verifier.builder.MethodVisitor;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;

class MessagingGiven
implements Given,
MethodVisitor<Given>,
BodyMethodVisitor {
    private final BlockBuilder blockBuilder;
    private final GeneratedClassMetaData generatedClassMetaData;
    private final List<Given> givens = new LinkedList<Given>();

    MessagingGiven(BlockBuilder blockBuilder, GeneratedClassMetaData generatedClassMetaData, BodyParser bodyParser) {
        this.blockBuilder = blockBuilder;
        this.generatedClassMetaData = generatedClassMetaData;
        this.givens.addAll(Arrays.asList(new MessagingBodyGiven(this.blockBuilder, new BodyReader(this.generatedClassMetaData), bodyParser), new MessagingHeadersGiven(this.blockBuilder)));
    }

    @Override
    public MethodVisitor<Given> apply(SingleContractMetadata metadata) {
        this.startBodyBlock(this.blockBuilder, "given:");
        this.blockBuilder.addIndented("ContractVerifierMessage inputMessage = contractVerifierMessaging.create(").addEmptyLine().indent();
        this.givens.stream().filter(given -> given.accept(metadata)).forEach(given -> {
            given.apply(metadata);
            this.blockBuilder.addEmptyLine();
        });
        this.blockBuilder.unindent().unindent().startBlock().addIndented(")").addEndingIfNotPresent().addEmptyLine().endBlock();
        return this;
    }

    @Override
    public boolean accept(SingleContractMetadata metadata) {
        return metadata.isMessaging() && metadata.getContract().getInput().getTriggeredBy() == null;
    }
}

