/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.messaging.integration;

import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifier;
import org.springframework.cloud.contract.verifier.messaging.integration.ContractVerifierHelper;
import org.springframework.cloud.contract.verifier.messaging.integration.SpringIntegrationStubMessages;
import org.springframework.cloud.contract.verifier.messaging.internal.ContractVerifierMessaging;
import org.springframework.cloud.contract.verifier.messaging.noop.NoOpContractVerifierAutoConfiguration;
import org.springframework.cloud.contract.verifier.messaging.stream.ContractVerifierStreamAutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.Message;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={Message.class})
@AutoConfigureBefore(value={NoOpContractVerifierAutoConfiguration.class})
@AutoConfigureAfter(value={ContractVerifierStreamAutoConfiguration.class})
public class ContractVerifierIntegrationConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public MessageVerifier<Message<?>> contractVerifierMessageExchange(ApplicationContext applicationContext) {
        return new SpringIntegrationStubMessages(applicationContext);
    }

    @Bean
    @ConditionalOnMissingBean
    public ContractVerifierMessaging<Message<?>> contractVerifierMessaging(MessageVerifier<Message<?>> exchange) {
        return new ContractVerifierHelper(exchange);
    }
}

